<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/mafiler"
	xmlns:ns1="http://www.sec.gov/edgar/common"
	xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma"
	xmlns:n2="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns3="http://www.sec.gov/edgar/ma_drp">
	
	
	
	<!--Schedule D templates -->
	
<xsl:template name="scheduleD" >

			<p>Certain items in Part I of Form MA require additional information on Schedule D.  Use this Schedule D to report details for items listed below.  Report only new information or changes/updates to previously submitted information.  Do not repeat previously submitted information.</p>

			<p>This is an:  <xsl:choose>
						<xsl:when
							test="count(m1:formData/m1:scheduleD/m1:type/ns2:add) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose><b>INITIAL or </b><xsl:choose>
						<xsl:when
							test="count(m1:formData/m1:scheduleD/m1:type/ns2:amend) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose><b>AMENDED Schedule D or </b><xsl:choose>
						<xsl:when
							test="count(m1:formData/m1:scheduleD/m1:type/ns2:delete) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose><b><em>ANNUAL UPDATE </em></b></p><br/>
					

			<p><b>SECTION 1-B  Other Names under which <em>Municipal Advisor-Related</em> Business is Conducted </b></p>
 
			<p>List the applicant's other business names and the jurisdictions in which they are used.  A separate Schedule D must be completed for each business name, and the jurisdictions where that name is used.</p>
					
			<xsl:for-each select="m1:formData/m1:businessConductedOtherNames/m1:businessConductedOtherName">
				<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdStyle1">
				Select only one:  		
					<xsl:choose>
						<xsl:when
							test="count(m1:addDeleteAmend/ns2:add) &gt; 0 or count(m1:addDeleteAmend/ns2:newAdd) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					Add
					<xsl:choose>
						<xsl:when
							test="count(m1:addDeleteAmend/ns2:delete) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					Delete  
					<xsl:choose>
						<xsl:when
							test="count(m1:addDeleteAmend/ns2:amend) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					Amend
				</div>	
			</div>
			<div style="clear:both"></div>			
		</div>			
		
		
       <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">Name: <br/><textarea name="firmname" cols="64" rows="6" readonly="1">
							
					<xsl:value-of
					select="string(m1:name)" />
			</textarea>
			</div>
			</div>
			<div style="clear:both"></div>	
			</div>
			
			
			 <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01smallcol1">Jurisdictions:	<br/>
							</div>
			<!-- <input
				type="text"
				name="Jurisdictions"
				readonly="1">
				<xsl:attribute
					name="value">
					<xsl:value-of
					select="string(m1:jurisdictions)" />
				</xsl:attribute>
			</input> -->
			<div class="tdstyle1max01sched tdmax01col2">
			<div class="fakeBox"> 
                     <span >
                   <xsl:call-template name="stateDescription">
                       <xsl:with-param name="stateCode" select="string(m1:jurisdictions)"/>
                    </xsl:call-template>
              		</span>
                <span>
                	<xsl:text>&#160;</xsl:text>
                </span>
           		</div>

			</div>
			</div>
			<div style="clear:both"></div>	
			</div>
			
						
		</xsl:for-each>
					
			<p><b>SECTION 1-D   Additional Registrations of the Applicant </b></p>
 
			<p>Indicate any additional registrations with federal or state regulators, and the relevant registration number.  A separate Schedule D must be completed for each such registration. </p>
 
			 <xsl:for-each select="m1:formData/m1:additionalRegistrations/m1:additionalRegistration">
			  <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01smallcol1">Name:<br/><textarea name="firmname" cols="64" rows="6" readonly="1">
								<xsl:value-of
								select="string(m1:nameAndRegistration/ns2:name)" />
						</textarea></div>
						</div>
						<div style="clear:both"></div>	
						</div>
						
						 <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01smallcol1">Registration No.:<br/> <textarea name="firmname" cols="64" rows="6" readonly="1">
								<xsl:value-of
							select="string(m1:nameAndRegistration/ns2:registrationId)" />
						</textarea></div>
						</div>
						<div style="clear:both"></div>
				</div>
			
			</xsl:for-each>

			<p><b>SECTION 1-E  Additional Offices at which the Applicant’s <em>Municipal Advisor-Related</em> Business is Conducted  </b></p>

			<p>Provide the location of the largest five additional offices (in terms of numbers of <em>employees</em>) at which the applicant’s <em>municipal advisor-related</em> business is conducted other than applicant’s <em>principal office and place of business</em>.  A separate Schedule D must be completed for each such office.</p>


			<xsl:for-each select="m1:formData/m1:additionalOffices/m1:additionalOffice">
    			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdStyle1">
    			Select only one: 					
    			<xsl:choose>
						<xsl:when
							test="count(m1:addDeleteAmend/ns2:add) &gt; 0 or count(m1:addDeleteAmend/ns2:newAdd) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>Add<xsl:choose>
						<xsl:when
							test="count(m1:addDeleteAmend/ns2:delete) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>Delete  <xsl:choose>
						<xsl:when
							test="count(m1:addDeleteAmend/ns2:amend) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>Amend
				</div>
				
				</div>
					<div style="clear:both"></div>				
				</div>	
				
				<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						
							<div class="tdstyle1max01sched tdmax01col1">Street Address 1:
							</div>
							<div class="tdstyle1max01sched tdmax01col2">Street Address 2:
							</div>
							<br></br>
							<br></br>
							
							<div class="tdstyle1max01sched tdmax01col1 tdmaschedDmargins">
								<input type="text" class="tdmaschedDmargins" name="street1" readonly="1" size="40">
									<xsl:attribute name="value">
										<xsl:value-of select="string(m1:officeInfo/m1:addressInfo/ns2:address/ns1:street1)" />
									</xsl:attribute>
								</input>
								</div>
								
								<div class="tdstyle1max01sched tdmax01col1 tdmaschedDmargins">
						<input type="text" class="tdmaschedDmargins" name="street1" readonly="1"  size="40">
	                        <xsl:attribute  name="value">
	                            <xsl:value-of select="string(m1:officeInfo/m1:addressInfo/ns2:address/ns1:street2)" />
	                        </xsl:attribute>
                    	</input>
                    </div>	
								
								<div style="clear:both"></div>
				</div>
								
									
				
				
				<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						
							<div class="tdstyle1max01sched tdmax01col1">City:
							</div>
							<div class="tdstyle1max01sched tdmax01col1">State/Country:
							</div>
							<br></br>
							<br></br>
							<div class="tdstyle1max01sched tdmax01col1 tdmaschedDmargins">
								<input type="text" class="tdmaschedDmargins" name="city" readonly="1" size="30">
									<xsl:attribute name="value">
										<xsl:value-of select="string(m1:officeInfo/m1:addressInfo/ns2:address/ns1:city)" />
									</xsl:attribute>
								</input>
							</div>

								<div class="tdstyle1max01sched tdmax01col1 tdmaschedDmargins">
								<div class="fakeBox fakeBox4"> 
			                        <span >
					                    <xsl:call-template name="stateDescription">
					                        <xsl:with-param name="stateCode" select="string(m1:officeInfo/m1:addressInfo/ns2:address/ns1:stateOrCountry)"/>
					                     </xsl:call-template>
			                 		</span>
					                 <span>
					                 	<xsl:text>&#160;</xsl:text>
					                 </span>
			              		</div>
							</div>
						 <div style="clear:both"></div>					
					</div>
			
			 <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						
							<div class="tdstyle1max01sched tdmax01col1">Postal Code:
							</div>
							<br></br>
							<br></br>
							<div class="tdstyle1max01sched tdmax01col1 tdmaschedDmargins">
								<input type="text" name="city" readonly="1" size="30">
									<xsl:attribute name="value">
										<xsl:value-of
										select="string(m1:officeInfo/m1:addressInfo/ns2:address/ns1:zipCode)" />
									</xsl:attribute>
								</input>
							</div>					
						<div style="clear:both"></div>					
			 </div>
			 
			 <div class="tableStyle" style="margin-left:0; margin-right:0;">	
				<div class="tableRow">
				<div class="tdstyle1max01sched tdmax01col1">Is this address a private residence?
				
				<xsl:choose>
		                        <xsl:when
		                            test="m1:officeInfo/m1:addressInfo/ns2:residentialAddressFlag = 'Y'">
		                            <img
		                                src="Images/box-checked.jpg" alt="checkbox checked" />
		                        </xsl:when>
		                        <xsl:otherwise>
		                            <img
		                                src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
		                        </xsl:otherwise>
		                    </xsl:choose>
		           	 </div>
		          </div>
				  <div style="clear:both"></div>
				  </div>
				  
				  
	            <div class="tableStyle" style="margin-left:0; margin-right:0;">	
				<div class="tableRow">
				<div class="tdstyle1max01sched tdmax01singlecol tdmax01textmargins">
				A private residential address will not be included in publicly available versions of this registration form.
				</div> 
				</div>
				<div style="clear:both"></div>
				</div>
			 
			 
			<div class="tableStyle" style="margin-left:0; margin-right:0;">							
							<div class="tdstyle1max01sched tdmax01col1">Telephone number at this location:
							</div>
							<div class="tdstyle1max01sched tdmax01col1">Fax number (if any) a this location:
							</div>
							<br></br>
							<br></br>
							<div class="tdstyle1max01sched tdmax01col1 tdmaschedDmargins">
						<input type="text" name="city" readonly="1" size="30">
							<xsl:attribute name="value">
								<xsl:value-of select="string(m1:officeInfo/m1:phoneNumber)" />
							</xsl:attribute>
						</input>
					</div>
					<div class="tdstyle1max01sched tdmax01col1 tdmaschedDmargins">
						<input type="text" name="city" readonly="1" size="30">
							<xsl:attribute name="value">
								<xsl:value-of select="string(m1:officeInfo/m1:faxNumber)" />
							</xsl:attribute>
						</input>
					</div>
				
				<div style="clear:both"></div>
			  </div>					
				
			<!-- 	<p> For non-US telephone and fax numbers, include country code with area code and local number.</p> -->
			</xsl:for-each>


		<p><b>SECTION 1-F  Additional Website Addresses </b></p>
		<p>List any additional website addresses of the applicant.  A separate Schedule D must be completed for each such website address. </p>
				<xsl:for-each select="m1:formData/m1:additionalWebAddresses/m1:additionalWebAddress">
				    <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdStyle1">
				    			Select only one:  		
				    			<xsl:choose>
										<xsl:when
											test="count(m1:addDeleteAmend/ns2:add) &gt; 0 or count(m1:addDeleteAmend/ns2:newAdd) &gt; 0">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>Add
									<xsl:choose>
										<xsl:when
											test="count(m1:addDeleteAmend/ns2:delete) &gt; 0">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>Delete  
									<xsl:choose>
										<xsl:when
											test="count(m1:addDeleteAmend/ns2:amend) &gt; 0">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>Amend
								</div>
								</div>
								<div style="clear:both"></div>			  
				    		</div>
							
				    		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">Website Address:<br/> 
				                    		<textarea name="firmname" cols="64" rows="6" readonly="1">
											<xsl:value-of
											select="string(m1:webAddress)" />
									</textarea>			
				    			</div>				    		
				    		</div>
							<div style="clear:both"></div>			  
				    		</div>
				    	
				    
				</xsl:for-each>
					
		
				<p><b>SECTION 1-I  Location of Books and Records </b></p>
				 
				<p>Complete the following information for each location at which the applicant keeps books and records, other than its <em>principal office and place of business</em>.  A separate Schedule D must be completed for each location. </p>


				<xsl:for-each select="m1:formData/m1:booksAndRecordsLocations/m1:booksAndRecordsLocation">
				     <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdStyle1">
				    			Select only one: 
									<xsl:choose>
										<xsl:when
											test="count(m1:type/ns2:add) &gt; 0 or count(m1:type/ns2:newAdd) &gt; 0">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>Add<xsl:choose>
										<xsl:when
											test="count(m1:type/ns2:delete) &gt; 0">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>Delete  <xsl:choose>
										<xsl:when
											test="count(m1:type/ns2:amend) &gt; 0">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>Amend
								</div>
							</div>
							<div style="clear:both"></div>						
					</div>
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">
					                Name of entity where books and records are kept:<br/>
				                    <textarea name="locationname" cols="64" rows="6" readonly="1">
											<xsl:value-of
											select="string(m1:locationName)" />
									</textarea>			
								</div>
							</div>
							<div style="clear:both"></div>						
					</div>
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;">							
							<div class="tdstyle1max01sched tdmax01col1">Street Address 1:
							</div>
							<div class="tdstyle1max01sched tdmax01col1">Street Address 2:
							</div>
							<br></br>
							<br></br>
							<div class="tdstyle1max01sched tdmax01col1 tdmaschedDmargins">
									<input type="text" name="street1" readonly="1" size="40">
										<xsl:attribute name="value">
											<xsl:value-of select="string(m1:contact/m1:addressInfo/ns2:address/ns1:street1)" />
										</xsl:attribute>
									</input>
							</div>
									
									<div class="tdstyle1max01sched tdmax01col1 tdmaschedDmargins">
									<input type="text" name="street1" readonly="1" size="40">
	                        			<xsl:attribute name="value">
	                            			<xsl:value-of select="string(m1:contact/m1:addressInfo/ns2:address/ns1:street2)" />
	                        			</xsl:attribute>
	                    			</input>
	                  			  </div>							
								<div style="clear:both"></div>							
						</div>
									
						<div class="tableStyle" style="margin-left:0; margin-right:0;">							
							<div class="tdstyle1max01sched tdmax01col1">City:
							</div>
							<div class="tdstyle1max01sched tdmax01col1">State/Country:
							</div>
							<br></br>
							<br></br>
							<div class="tdstyle1max01sched tdmax01col1 tdmaschedDmargins">
									<input type="text" name="city" readonly="1" size="30">
										<xsl:attribute name="value">
											<xsl:value-of select="string(m1:contact/m1:addressInfo/ns2:address/ns1:city)" />
										</xsl:attribute>
									</input>
					
								</div>
								<div class="tdstyle1max01sched tdmax01col1 tdmaschedDmargins">
									<!-- 
									<input type="text" name="city" readonly="1" size="45">
										<xsl:attribute name="value">
											<xsl:value-of select="string(m1:contact/m1:addressInfo/ns2:address/ns1:stateOrCountry)" />
										</xsl:attribute>
									</input>
									-->
									<div class="fakeBox fakeBox4"> 
				                        <span >
				                    		<xsl:call-template name="stateDescription">
				                        		<xsl:with-param name="stateCode" select="string(m1:contact/m1:addressInfo/ns2:address/ns1:stateOrCountry)" />
				                     		</xsl:call-template>
				                 		</span>
				    	                <span>
				                 			<xsl:text>&#160;</xsl:text>
				                 		</span>
				              		</div>
								</div>
							
							<div style="clear:both"></div>								
					</div>	
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;">							
							<div class="tdstyle1max01sched tdmax01col1">Postal Code:
							</div>
							<br></br>
							<br></br>							
							<div class="tdstyle1max01sched tdmax01col1 tdmaschedDmargins">
									<input type="text" name="city" readonly="1" size="30">
										<xsl:attribute name="value">
												<xsl:value-of select="string(m1:contact/m1:addressInfo/ns2:address/ns1:zipCode)" />
										</xsl:attribute>
									</input>
								</div>							
							
						<div style="clear:both"></div>					
					</div>	
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">Is this address a private residence?
							
									<xsl:choose>
				                        <xsl:when
				                            test="m1:contact/m1:addressInfo/ns2:residentialAddressFlag = 'Y'">
				                            <img
				                                src="Images/box-checked.jpg" alt="checkbox checked" />
				                        </xsl:when>
				                        <xsl:otherwise>
				                            <img
				                                src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				                        </xsl:otherwise>
				                    </xsl:choose>
				             </div>	
							</div>							 
				       <div style="clear:both"></div>	
					</div>

					   
		             <div class="tableStyle" style="margin-left:0; margin-right:0;">						
							<div class="tdstyle1max01sched tdmax01col1">Telephone number at this location:
							</div>
							<div class="tdstyle1max01sched tdmax01col1">Fax number (if any) at this location:
							</div>
							<br></br>
							<br></br>
							<div class="tdstyle1max01sched tdmax01col1 tdmaschedDmargins">
								<input type="text" name="city" readonly="1" size="30">
									<xsl:attribute name="value">
										<xsl:value-of  select="string(m1:contact/m1:phoneNumber)" />
									</xsl:attribute>
								</input>
							</div>
							<div class="tdstyle1max01sched tdmax01col1 tdmaschedDmargins">
								<input type="text" name="city" readonly="1" size="30">
									<xsl:attribute name="value">
										<xsl:value-of select="string(m1:contact/m1:faxNumber)" />
									</xsl:attribute>
								</input>
							</div>
						
						<div style="clear:both"></div>		
					</div>					
				
				
				
				
				<div class="tableStyle" style="margin-left:0; margin-right:0;">	
					<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01singlecol tdmax01textmargins">
		          		For non-US telephone and fax numbers, include country code with area code and local number.
					</div>
				  </div>
				  <div style="clear:both"></div>	
				</div>
				
				<div class="tableStyle" style="margin-left:0; margin-right:0; border-bottom:none">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">This is (Select only one):
							</div>
						<div class="tdstyle1max01sched tdmax01col2">
						<xsl:choose>
							<xsl:when
								test="count(m1:locationType/m1:branchOrAffiliate) &gt; 0">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>one of applicant’s branch offices or <em>affiliates</em>. </div>
					</div>
					 <div style="clear:both"></div>
					 </div>
					 
					<div class="tableStyle" style="margin-left:0; margin-right:0;border-top:none;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">
							</div>
							<div class="tdstyle1max01sched tdmax01col2" style="padding-bottom:5px;">
							<xsl:choose>
							<xsl:when
								test="count(m1:locationType/m1:third-party) &gt; 0">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>a third-party unaffiliated record keeper.</div>
					</div>
					 <div style="clear:both"></div>
					 </div>
					 
					 
					<div class="tableStyle" style="margin-left:0; margin-right:0;border-top:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">
							</div>
							<div class="tdstyle1max01sched tdmax01col2" style="padding-bottom:5px;">
							<xsl:choose>
							<xsl:when
								test="count(m1:locationType/m1:other) &gt; 0">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Other</div>
					</div>
					 <div style="clear:both"></div>
					 </div>
					
				
				 <div class="tableStyle" style="margin-left:0; margin-right:0;border-top:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">Briefly describe the books and records kept at the location(s) you checked.  If you checked “other,” describe additionally all such location(s).
							</div>
					<div class="tdstyle1max01sched tdmax01col1">		
					<div class="fakeBox">
					    <xsl:value-of select="string(m1:description)" />
		                 <span>
		               		 <xsl:text>&#160;</xsl:text>
		               </span>
	               </div>
				</div>
				</div>
				<div style="clear:both"></div>
				</div>				
				</xsl:for-each>
		
				<p><b>SECTION 1-J  Registration with Foreign Financial Regulatory Authorities</b></p>
				 
				<p>List the full name, in English, of each <em>foreign financial regulatory authority</em>, provide the foreign registration number (if any), and list the full name, in English, of the country with which the applicant is registered.  A separate Schedule D must be completed for each <em>foreign financial regulatory authority</em> with whom the applicant is registered. </p>
				
				<xsl:for-each select="m1:formData/m1:foreignRegulatoryAuthorityRegistrations/m1:foreignRegulatoryAuthorityRegistration">
				     <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdStyle1">Select only one:
				      		<xsl:choose>
										<xsl:when
											test="count(m1:type/ns2:add) &gt; 0 or count(m1:type/ns2:newAdd) &gt; 0">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>Add<xsl:choose>
										<xsl:when
											test="count(m1:type/ns2:delete) &gt; 0">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>Delete  <xsl:choose>
										<xsl:when
											test="count(m1:type/ns2:amend) &gt; 0">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>Amend
								</div>
							</div>
						<div style="clear:both"></div>
					</div>			
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1"> English Name of <em>Foreign Financial Regulatory Authority</em>: <br/>
							
									<textarea name="firmname" cols="64" rows="6" readonly="1">
										<xsl:value-of select="m1:englishFFRAName" />
									</textarea>
								</div>
							</div>
							
							<div style="clear:both"></div>
					</div>	
					
							<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1"> Foreign Registration  No. (if any): <br/>  
									<textarea name="foreignnumber" cols="64" rows="6" readonly="1">
										<xsl:value-of
										select="m1:foreignRegNumber" />
									</textarea>
								</div>
							</div>
							<div style="clear:both"></div>
					</div>	
					
							<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">English Name of Country: <br/>  	 
										<!-- 
									<input
										type="text"
										name="city"
										readonly="1" size="30">
										<xsl:attribute
											name="value">
											<xsl:value-of
											select="string(m1:englishCountryName)" />
										</xsl:attribute>
									</input>	
									-->
									<div class="fakeBox"> 
					                   <span >
						                    <xsl:call-template name="stateDescription">
						                        <xsl:with-param name="stateCode" select="string(m1:englishCountryName)" />
						                     </xsl:call-template>
						                </span>
						                 <span>
						                	 <xsl:text>&#160;</xsl:text>
						                 </span>
					              	</div>
								</div>
							</div>
				 		<div style="clear:both"></div>
					</div>	
					
				</xsl:for-each>

				<p><b>SECTION 1-K  Business <em>Affiliates</em> of the Applicant </b>	</p>	
					
				<!-- <p>Provide the name of any domestic or foreign business <em>affiliate</em> of the applicant, and any federal, state, or foreign registration of such <em>affiliate</em> and the registration number.  A separate Schedule D must be completed for each such <em>affiliate</em>. </p> -->
				<p>Provide the name of any domestic or foreign business <em>affiliate</em> of the applicant and any federal, state, or foreign registration of such <em>affiliate</em> and the registration number.   A separate Schedule D must be completed for each such <em>affiliate</em>.</p>
				<xsl:for-each select="m1:formData/m1:businessAffiliates/m1:businessAffiliate">
				<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">Name of <em>Affiliate</em>: <br/>
							<textarea name="firmname" cols="64" rows="6" readonly="1">
											<xsl:value-of
											select="string(m1:affiliateName)" />
							</textarea>
							</div>
						</div>					
				
				<div style="clear:both"></div>
					</div>	
				<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">1.	Does the <em>affiliate</em> have an applicable federal, state, or foreign registration?
							</div>
							<div class="tdstyle1max01sched tdmax01col2">
							<xsl:choose>
										<xsl:when
											test="m1:hasApplicableRegistration = 'Y'">
											<img
												src="Images\radio-checked.jpg"  alt="radio button checked"/> Yes <img
												src="Images\radio-unchecked.jpg" alt="radio button unchecked" />No
										</xsl:when>
										<xsl:when
											test="m1:hasApplicableRegistration = 'N'">
											<img
												src="Images\radio-unchecked.jpg" alt="radio button unchecked" /> Yes <img
												src="Images\radio-checked.jpg"  alt="radio button checked"/>No
										</xsl:when>
										<xsl:otherwise>
										<img
												src="Images\radio-unchecked.jpg" alt="radio button unchecked" />Yes
											<img
												src="Images\radio-unchecked.jpg" alt="radio button unchecked" />No
										</xsl:otherwise>
									</xsl:choose>
							</div>
						</div>
					<div style="clear:both"></div>
				</div>
				
				
				<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">2. Provide the following details:							
							</div>
						</div>
						<div style="clear:both"></div>
				</div>
						<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">
							
							(a)	Name of Agency Issuing Registration (in English):<br/> 
							
							<textarea name="firmname" cols="64" rows="6" readonly="1">
											<xsl:value-of
											select="string(m1:applicableRegistration/m1:issuingAgencyName)" />
									</textarea>
							
							</div>
						</div>
						<div style="clear:both"></div>
				</div>
						
					<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">
							
							(b)	Registration No., if any:  <br/>
							
							<textarea name="firmname" cols="64" rows="6" readonly="1">
											<xsl:value-of
											select="string(m1:applicableRegistration/m1:registrationNumber)" />
									</textarea>
							
							</div>
						</div>	
					<div style="clear:both"></div>
				</div>	
				
						<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01singlecol tdmax01textmargins">
								(c) Provide the jurisdiction (check the appropriate box and if a US state or other jurisdiction, or a foreign country, provide the name of the jurisdiction):
							</div>
						</div>
				<div style="clear:both"></div>
				</div>	
				
						<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">										
											<xsl:choose>
										<xsl:when
											test="count(m1:applicableRegistration/m1:jurisdiction/m1:US_Federal) &gt; 0">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>US Federal</div>
											</div>
										<div style="clear:both"></div>
				</div>	
				
					<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">										
							<xsl:choose>
										<xsl:when
											test="count(m1:applicableRegistration/m1:jurisdiction/m1:US_State) &gt; 0">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>US State or Other US Jurisdiction:  
									<br/>(specify):
				                    <!-- <input
										type="text"
										
										readonly="1">
										<xsl:attribute
											name="value">
											<xsl:value-of
											select="string(m1:applicableRegistration/m1:jurisdiction/m1:US_State)" />
										</xsl:attribute>
									</input> -->
									<div class="fakeBox"> 
					                   <span >
						                    <xsl:call-template name="stateDescription">
						                        <xsl:with-param name="stateCode" select="string(m1:applicableRegistration/m1:jurisdiction/m1:US_State)" />
						                     </xsl:call-template>
						                </span>
						                 <span>
						                	 <xsl:text>&#160;</xsl:text>
						                 </span>
					              	</div>					
									</div>
								</div>
								<div style="clear:both"></div>
				</div>	
								<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">	
										<xsl:choose>
											<xsl:when
												test="count(m1:applicableRegistration/m1:jurisdiction/m1:ForeignCountry) &gt; 0">
												<img
													src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>
												<img
													src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Foreign Country Name (in English): <br/>(specify):
										<!-- <input
											type="text"
											
											readonly="1">
											<xsl:attribute
												name="value">
												<xsl:value-of
												select="string(m1:applicableRegistration/m1:jurisdiction/m1:ForeignCountry)" />
											</xsl:attribute>
										</input> -->
										<div class="fakeBox"> 
						                   <span >
							                    <xsl:call-template name="stateDescription">
							                        <xsl:with-param name="stateCode" select="string(m1:applicableRegistration/m1:jurisdiction/m1:ForeignCountry)"/>
							                     </xsl:call-template>
							                </span>
							                 <span>
							                	 <xsl:text>&#160;</xsl:text>
							                 </span>
					              		</div>	
									</div>
								</div>
							<div style="clear:both"></div>
				</div>	
									

			</xsl:for-each>

			<p><b>SECTION 3  Successions </b></p>		
			 
			<p>Complete the following information if succeeding to the business of a currently-registered <em>municipal advisor</em>.  If the applicant succeeded more than one <em>municipal advisory firm</em> in the succession being reported on this Form MA, a separate Schedule D must be completed for each predecessor firm.  See Instruction 1 of the Specific Instructions for Certain Items in Form MA included in the General Instructions.  </p>

			<xsl:for-each select="m1:formData/m1:successionInfo/m1:successions">
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">
				Name of Predecessor <em>Municipal Advisory Firm</em>:  	<br/>
				<textarea name="firmname" cols="64" rows="6" readonly="1">
					<xsl:value-of select="string(m1:nameOfFirm)" />
				</textarea>
					</div>	
				</div>
			<div style="clear:both"></div>
				</div>	

			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">
							<xsl:choose>
								<xsl:when test="count(m1:baseRegistrations/m1:maRegistration) &gt; 0">
									<img src="Images/box-checked.jpg" alt="checkbox checked" />
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
								</xsl:otherwise>
							</xsl:choose>
							<em>Municipal Advisor </em> 
							<br/>
							
							<!-- <input  type="text" readonly="1"> 
								<xsl:attribute name="value"> 	
									<xsl:value-of select="string(m1:baseRegistrations/m1:maRegistration/ns2:fileNumber)" />	
								</xsl:attribute>
							</input> -->
							<div class="tdstyle1max01sched tdmax01col1">&#160;&#160;<em>SEC</em> File No.: 
											<input  type="text" readonly="1"> 
												<xsl:attribute name="value"> 	
													<xsl:value-of select="string(m1:baseRegistrations/m1:maRegistration/ns2:fileNumber)" />	
												</xsl:attribute>
											</input>
										</div>
									</div>
								
							</div>
						<div style="clear:both"></div>
				</div>	
					<!-- <div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="tdStyle" style="margin-left:0; margin-right:0; width:100%;">
							<xsl:choose>
									<xsl:when test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:msdRegistration) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>Municipal Securities Dealer<em>SEC</em> File No.:  
								<input  type="text" readonly="1"> 
									<xsl:attribute name="value"> 	
										<xsl:value-of select="string(m1:baseRegistrations/m1:baseRegistrations/ns2:msdRegistration/ns2:fileNumber)" />	
									</xsl:attribute>
								</input>
						</div>
					</div> -->
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">
							<xsl:choose>
								<xsl:when test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:msdRegistration) &gt; 0">
									<img src="Images/box-checked.jpg" alt="checkbox checked" />
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
								</xsl:otherwise>
							</xsl:choose>
							Municipal Securities Dealer 
							<br/>
							<div class="tdstyle1max01sched tdmax01col1">&#160;&#160;<em>SEC</em> File No.: 
											<input  type="text" readonly="1"> 
												<xsl:attribute name="value"> 	
													<xsl:value-of select="string(m1:baseRegistrations/m1:baseRegistrations/ns2:msdRegistration/ns2:fileNumber)" />	
												</xsl:attribute>
											</input>
										</div>
									</div>								
							</div>
							<div style="clear:both"></div>
				</div>
					
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">
							<xsl:choose>
								<xsl:when test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:bdRegistration) &gt; 0">
									<img src="Images/box-checked.jpg" alt="checkbox checked" />
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
								</xsl:otherwise>
							</xsl:choose>
							Broker-Dealer
							<br></br>
							</div>
							</div>
							<div style="clear:both"></div>
				</div>
								<div class="tableStyle" style="margin-left:0; margin-right:0;border-top:none;">	
						<div class="tableRow">							
							<div class="tdstyle1max01sched tdmax01col1">&#160;&#160;<em>SEC</em> File No.: 
											<input type="text" readonly="1"> 
												<xsl:attribute name="value"> 	
													<xsl:value-of select="string(m1:baseRegistrations/m1:baseRegistrations/ns2:bdRegistration/ns2:fileNumber)"/>	
												</xsl:attribute>
											</input>
								</div>
								<div class="tdstyle1max01sched tdmax01col2">Organization <em>CRD</em> No.:  
											<input  type="text" readonly="1"> 
												<xsl:attribute name="value"> 	
													<xsl:value-of select="string(m1:baseRegistrations/m1:baseRegistrations/ns2:bdRegistration/ns2:crdNumber)" />	
												</xsl:attribute>
											</input>
										</div>								
									</div>
									
									<div style="clear:both"></div>								
							</div>
								
					<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">							
							<div class="tdstyle1max01sched tdmax01col1">
								<xsl:choose>
									<xsl:when
										test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								<em>Investment Adviser</em> 
								<br/>
								</div>
								</div>									
									<div style="clear:both"></div>								
							</div>
								
					<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;border-top:none;">	
						<div class="tableRow">							
							<div class="tdstyle1max01sched tdmax01col1">
												&#160;&#160;
												<xsl:choose>
													<xsl:when
														test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:secRegistration) &gt; 0">
														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												<em>SEC</em>-Registered
												</div>
												</div>									
									<div style="clear:both"></div>								
							</div>
												
												
					<div class="tableStyle" style="margin-left:0; margin-right:0;border-top:none;">	
						<div class="tableRow">							
							<div class="tdstyle1max01sched tdmax01col1">
															&#160;&#160;&#160;&#160;<em>SEC</em> File No.:   
															<input  type="text" readonly="1"> 
																<xsl:attribute name="value"> 	
																	<xsl:value-of select="string(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:secRegistration/ns2:fileNumber)" />	
																</xsl:attribute>
															</input>
															</div>
															
															<div class="tdstyle1max01sched tdmax01col1">Organization <em>CRD</em> No.: 
															<input  type="text" readonly="1"> 
																<xsl:attribute name="value"> 	
																	<xsl:value-of select="string(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:secRegistration/ns2:crdNumber)" />	
																</xsl:attribute>
															</input>
														</div>															
													</div>
													<div style="clear:both"></div>												
												</div>
											
					<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">							
							<div class="tdstyle1max01sched tdmax01col1">
												&#160;&#160;<xsl:choose>
													<xsl:when test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:exemptAdvisor) &gt; 0">
														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>Exempt Reporting Adviser 
										</div>
										</div>
													<div style="clear:both"></div>												
										</div>
										
					<div class="tableStyle" style="margin-left:0; margin-right:0;border-top:none;">	
						<div class="tableRow">							
							<div class="tdstyle1max01sched tdmax01col1">
									&#160;&#160;&#160;&#160;<em>SEC</em> File No.:   
									<input type="text" readonly="1"> 
										<xsl:attribute name="value"> 	
											<xsl:value-of select="string(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:exemptAdvisor/ns2:fileNumber)" />	
										</xsl:attribute>
									</input>
									</div>
									<div class="tdstyle1max01sched tdmax01col1">Organization <em>CRD</em> No.:  
									<input  type="text" readonly="1"> 
										<xsl:attribute name="value"> 	
											<xsl:value-of select="string(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:exemptAdvisor/ns2:crdNumber)" />	
										</xsl:attribute>
									</input>
								</div>															
								</div>							
						<div style="clear:both"></div>						
						</div>		
					
								
					<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">							
							<div class="tdstyle1max01sched tdmax01col1">
											<xsl:choose>
												<xsl:when
													test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration) &gt; 0">
													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
												Registered in US State or Other US Jurisdiction 
											<br/>
											
											<div class="tdstyle1max01sched tdmax01col2">
											&#160;&#160;&#160;&#160;&#160;Organization <em>CRD</em> No.: 
												<input  type="text" readonly="1"> 
													<xsl:attribute name="value"> 	
														<xsl:value-of select="string(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration/ns2:crdNumber)" />	
													</xsl:attribute>
												</input>
											</div>
											</div>
										</div>
								<div style="clear:both"></div>						
						</div>		
							<br></br>
										
										
                        <u><em>Investment Adviser</em> Registration in a US State or Other Jurisdiction</u>: &quot;If predecessor <em>municipal advisory firm</em> is registered in a US state or other jurisdiction as an <em>investment adviser</em>, enter the organization <em>CRD</em> Number above.  In the table below, select each US state or jurisdiction in which the predecessor <em>municipal advisory firm</em> is so registered.&quot;
                                  
						<br></br>
						<br></br>

								
			<div class="tableStyle" style="margin-left:0; margin-right:0;">
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
												<strong>
													<div class="subLabel">US State or Jurisdiction</div>
													(Code)
												</strong>
											</div>
											<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
												<strong>
													<div class="subLabel">US State or Jurisdiction</div>
													(Code)
												</strong>
											</div>
										</div>
				<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
												<div class="subLabel">
								  				<xsl:choose>
													<xsl:when test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='AL']) &gt; 0 ">
														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
													Alabama
												</div>
												(AL)
											</div>
											<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
												<div class="subLabel">
												<xsl:choose>
													<xsl:when test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='MT']) &gt; 0 ">
														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
													Montana
												</div>
												(MT)
											</div>
										</div>
										<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
												<div class="subLabel">
												<xsl:choose>
													<xsl:when test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='AK']) &gt; 0 ">
														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
													Alaska
												</div>
												(AK)
											</div>
										<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
												<div class="subLabel">
												<xsl:choose>
													<xsl:when test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='NE']) &gt; 0 ">
														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
													Nebraska
												</div>
												(NE)
											</div>
										</div>
										<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
												<div class="subLabel">
													<xsl:choose>
														<xsl:when test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='AZ']) &gt; 0 ">
															<img src="Images/box-checked.jpg" alt="checkbox checked" />
														</xsl:when>
														<xsl:otherwise>
															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>
													Arizona
												</div>
												(AZ)
											</div>
											<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
												<div class="subLabel">
													<xsl:choose>
														<xsl:when test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='NV']) &gt; 0 ">
															<img src="Images/box-checked.jpg" alt="checkbox checked" />
														</xsl:when>
														<xsl:otherwise>
															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>
													Nevada
												</div>
												(NV)
											</div>
										</div>
										<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
												<div class="subLabel">
													<xsl:choose>
														<xsl:when test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='AR']) &gt; 0 ">
															<img src="Images/box-checked.jpg" alt="checkbox checked" />
														</xsl:when>
														<xsl:otherwise>
															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>
													Arkansas
												</div>
												(AR)
											</div>
											<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
												<div class="subLabel">
													<xsl:choose>
														<xsl:when test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='NH']) &gt; 0 ">
															<img src="Images/box-checked.jpg" alt="checkbox checked" />
														</xsl:when>
														<xsl:otherwise>
															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>
													New Hampshire
												</div>
												(NH)
											</div>
										</div>
										<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
												<div  class="subLabel">
													<xsl:choose>
														<xsl:when test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='CA']) &gt; 0 ">
															<img src="Images/box-checked.jpg" alt="checkbox checked" />
														</xsl:when>
														<xsl:otherwise>
															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>
													California
												</div>
												(CA)
											</div>
											<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
												<div class="subLabel">
													<xsl:choose>
														<xsl:when test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='NJ']) &gt; 0 ">
															<img src="Images/box-checked.jpg" alt="checkbox checked" />
														</xsl:when>
														<xsl:otherwise>
															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>
													New Jersey
												</div>
												(NJ)
											</div>
										</div>
										<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
												<div class="subLabel">
													<xsl:choose>
														<xsl:when test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='CO']) &gt; 0 ">
															<img src="Images/box-checked.jpg" alt="checkbox checked" />
														</xsl:when>
														<xsl:otherwise>
															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>
														Colorado
													</div>
													(CO)
												</div>
												<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
													<div class="subLabel">
														<xsl:choose>
															<xsl:when
																test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='NM']) &gt; 0 ">
																<img
																	src="Images/box-checked.jpg" alt="checkbox checked" />
																	  
															</xsl:when>
															<xsl:otherwise>
																<img
																	src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
															</xsl:choose>
															New Mexico
														</div>
														(NM)
														</div>
										</div>
										<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
												<div class="subLabel">
													<xsl:choose>
														<xsl:when
															test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='CT']) &gt; 0 ">
															<img src="Images/box-checked.jpg" alt="checkbox checked" />
														</xsl:when>
														<xsl:otherwise>
															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>
													Connecticut
												</div>
												(CT)
											</div>
											<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
												<div class="subLabel">
												<xsl:choose>
													<xsl:when
														test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='NY']) &gt; 0 ">
														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
													New York
												</div>
												(NY)
											</div>
										</div>
							<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
									<div class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='DE']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										Delaware
									</div>
									(DE)
								</div>
								<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
									<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='NC']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										North Carolina
									</div>
									(NC)
								</div>
							</div>
							<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
									<div class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='DC']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										Disctirct of Columbia
									</div>
									(DC)
								</div>
								<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
									<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='ND']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										North Dakota
									</div>
									(ND)
								</div>
							</div>
							<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
									<div class="subLabel">
										<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='FL']) &gt; 0 ">
											<img src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
										Florida
									</div>
									(FL)
								</div>
								<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
									<div
										class="subLabel">
										<xsl:choose>
											<xsl:when
												test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='OH']) &gt; 0 ">
												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>
												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Ohio
									</div>
									(OH)
								</div>
							</div>
							<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
									<div class="subLabel">
										<xsl:choose>
											<xsl:when
												test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='GA']) &gt; 0 ">
												<img
													src="Images/box-checked.jpg" alt="checkbox checked" />
													  
											</xsl:when>
											<xsl:otherwise>
												<img
													src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Georgia
									</div>
									(GA)
								</div>
							<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
									<div class="subLabel">
										<xsl:choose>
											<xsl:when
												test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='OK']) &gt; 0 ">
												<img
													src="Images/box-checked.jpg" alt="checkbox checked" />
													  
											</xsl:when>
											<xsl:otherwise>
												<img
													src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Oklahoma
									</div>
									(OK)
								</div>
							</div>
							<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
									<div class="subLabel">
										<xsl:choose>
											<xsl:when
												test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='GU']) &gt; 0 ">
												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>
												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Guam
									</div>
									(GU)
								</div>
								<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
									<div
										class="subLabel">
										<xsl:choose>
											<xsl:when
												test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='OR']) &gt; 0 ">
												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>
												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Oregon
									</div>
									(OR)
								</div>
							</div>
							<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
									<div class="subLabel">
										<xsl:choose>
											<xsl:when
												test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='HI']) &gt; 0 ">
												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>
												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Hawaii
									</div>
									(HI)
								</div>
							<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
									<div class="subLabel">
										<xsl:choose>
											<xsl:when
												test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='PA']) &gt; 0 ">
												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>
												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Pennsylvania
									</div>
									(PA)
								</div>
							</div>
							<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
									<div class="subLabel">
										<xsl:choose>
											<xsl:when
												test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='ID']) &gt; 0 ">
												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>
												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Idaho
									</div>
									(ID)
								</div>
								<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
									<div
										class="subLabel">
										<xsl:choose>
											<xsl:when
												test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='PR']) &gt; 0 ">
												<img
													src="Images/box-checked.jpg" alt="checkbox checked" />
													  
											</xsl:when>
											<xsl:otherwise>
												<img
													src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										
										</xsl:choose>
										Puerto Rico
									</div>
									(PR)
								</div>
							</div>
							<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
									<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='IL']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										Illinois
									</div>
									(IL)
								</div>
								<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
									<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='RI']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										Rhode Island
									</div>
									(RI)
								</div>
							</div>
							<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
									<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='IN']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										Indiana
									</div>
									(IN)
								</div>
							<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
									<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='SC']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										South Carolina
									</div>
									(SC)
								</div>
							</div>
							<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
									<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='IA']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										Iowa
									</div>
									(IA)
								</div>
								<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
									<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='SD']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										South Dakota
									</div>
									(SD)
								</div>
							</div>
							<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
									<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='KS']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										Kansas
									</div>
									(KS)
								</div>
							<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
									<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='TN']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										Tennessee
									</div>
									(TN)
								</div>
							</div>
							<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
									<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='KY']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										Kentucky
									</div>
									(KY)
								</div>
								<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
									<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='TX']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										Texas
									</div>
									(TX)
								</div>
							</div>
						<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
									<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='LA']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										Louisiana
									</div>
									(LA)
								</div>
								<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
									<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='UT']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										Utah
									</div>
									(UT)
								</div>
							</div>
							<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
									<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='ME']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										Maine
									</div>
									(ME)
								</div>
								<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
									<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='VT']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										Vermont
									</div>
									(VT)
								</div>
							</div>
							<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
									<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='MD']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										Maryland
									</div>
									(MD)
								</div>
								<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
									<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='VI']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										Virgin Islands
									</div>
									(VI)
								</div>
							</div>
							<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
									<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='MA']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										Massachusetts
									</div>
									(MA)
								</div>
								<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
									<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='VA']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										Virginia
									</div>
									(VA)
								</div>
							</div>
							<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
									<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='MI']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										Michigan
									</div>
									(MI)
								</div>
							<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
									<div
										class="subLabel">
							<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='WA']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										Washington
									</div>
									(WA)
								</div>
							</div>
							<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
									<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='MN']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										Minnesota
									</div>
									(MN)
								</div>
								<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
									<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='WV']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										West Virginia
									</div>
									(WV)
								</div>
							</div>
							<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
									<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='MS']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										Mississippi
									</div>
									(MS)
								</div>
									<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
									
									
										<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='WI']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										Wisconsin
									</div>
									(WI)
								</div>
							</div>
							<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div class="tdstyle1max01sched" style="width:50%;">
									<div
										class="subLabel">
								<xsl:choose>
										<xsl:when
											test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='MO']) &gt; 0 ">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
												  
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
										
							</xsl:choose>
										Missouri
									</div>
									(MO)
								</div>
								<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
								</div>
							</div>
							</div>								
			
		
		
		
		<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
			<div class="tableRow">
				<div class="tdstyle1max01sched tdmax01col1">
					<xsl:choose>
						<xsl:when
							test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:gsbdRegistration) &gt; 0">
							<img src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>Government Securities Broker-Dealer 
					</div>
					</div>
					<div style="clear:both"></div>
					</div>
					
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;">	
					<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1" style="padding-top:25px;">&#160;&#160;<em>SEC</em> File No.:  
									&#160;&#160;<input  type="text" readonly="1"> 
										<xsl:attribute name="value"> 	
											<xsl:value-of select="string(m1:baseRegistrations/m1:baseRegistrations/ns2:gsbdRegistration/ns2:fileNumber)" />	
										</xsl:attribute>
									</input>
									
									</div>	

									<div class="tdstyle1max01sched tdmax01col1"> Bank Identifier:  
									<!-- <input  type="text" readonly="1"> 
										<xsl:attribute name="value"> 	
											<xsl:value-of select="string(m1:baseRegistrations/m1:baseRegistrations/ns2:gsbdRegistration/ns2:bankId)" />	
										</xsl:attribute>
									</input> -->

									<div class="fakeBox">
                           					<xsl:value-of select="string(m1:baseRegistrations/m1:baseRegistrations/ns2:gsbdRegistration/ns2:bankId)" />
                       						<span>
                      							<xsl:text>&#160;</xsl:text>
                     							</span>
                     						</div>
                     					<!-- 	<textarea name="firmname" cols="64" rows="6" readonly="1">
										<xsl:value-of select="string(m1:baseRegistrations/m1:baseRegistrations/ns2:gsbdRegistration/ns2:bankId)" />
									</textarea> -->
								</div>									
							</div>							
							
							<div style="clear:both"></div>						
					</div>				
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
					<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">
				<xsl:choose>
						<xsl:when
							test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:otherRegistration) &gt; 0">
							<img src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>Other <em>SEC</em> Registration 
					</div>
					</div>
					<div style="clear:both"></div>						
					</div>		
					
					
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;">	
					<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">(Specify):  
									<!-- <input  type="text" readonly="1"> 
										<xsl:attribute name="value"> 	
											<xsl:value-of select="string(m1:baseRegistrations/m1:baseRegistrations/ns2:otherRegistration/ns2:description)" />	
										</xsl:attribute>
									</input>  --> 
									<div class="fakeBox">
                      					<xsl:value-of select="string(m1:baseRegistrations/m1:baseRegistrations/ns2:otherRegistration/ns2:description)" />
                  						<span>
                							<xsl:text>&#160;</xsl:text>
               							</span>
                					</div>
								</div>
							</div>
						
				<div style="clear:both"></div>
					</div>
					
				
				<div class="tableStyle" style="margin-left:0; margin-right:0;">	
					<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">				
									 <em>SEC</em> File No. (if any):   
									 <input  type="text" readonly="1"> 
									 	<xsl:attribute name="value"> 	
									 		<xsl:value-of select="string(m1:baseRegistrations/m1:baseRegistrations/ns2:otherRegistration/ns2:fileNumber)" />	
									 	</xsl:attribute>
									 </input> 
									</div>
										<div class="tdstyle1max01sched tdmax01col1">EDGAR CIK (if any): 
									<input  type="text" readonly="1"> 
										<xsl:attribute name="value"> 	
											<xsl:value-of select="string(m1:baseRegistrations/m1:baseRegistrations/ns2:otherRegistration/ns2:cik)" />	
										</xsl:attribute>
									</input>								
								</div>								
							</div>
							<div style="clear:both"></div>
				</div>
		
					
			<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
					<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">	
					&#160;&#160;&#160;<xsl:choose>
						<xsl:when
							test="count(m1:baseRegistrations/m1:baseRegistrations/ns2:anotherRegistration) &gt; 0">
							<img src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					Another Federal or State Regulator
					</div>
					</div>
					<div style="clear:both"></div>
				</div>
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;">	
					<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">(Specify):    
									<!-- <input type="text" readonly="1"> 
										<xsl:attribute name="value"> 	
											<xsl:value-of select="string(m1:baseRegistrations/m1:baseRegistrations/ns2:anotherRegistration/ns2:description)" />	
										</xsl:attribute>
									</input>  -->
									<div class="fakeBox" style="min-width:250px;">
                      					<xsl:value-of select="string(m1:baseRegistrations/m1:baseRegistrations/ns2:anotherRegistration/ns2:description)" />
                  						<span>
                							<xsl:text>&#160;</xsl:text>
               							</span>
                					</div>
									</div>
									<div class="tdstyle1max01sched tdmax01col1">Registration No. (if any): 
									<!-- <input type="text" readonly="1"> 
										<xsl:attribute name="value"> 	
											<xsl:value-of select="string(m1:baseRegistrations/m1:baseRegistrations/ns2:anotherRegistration/ns2:registrationId)" />	
										</xsl:attribute>
									</input> -->
									<div class="fakeBox">
                      					<xsl:value-of select="string(m1:baseRegistrations/m1:baseRegistrations/ns2:anotherRegistration/ns2:registrationId)" />
                  						<span>
                							<xsl:text>&#160;</xsl:text>
               							</span>
                					</div>
								</div>								
								</div>						
							<div style="clear:both"></div>						
							</div>		
</xsl:for-each>


<p><b>SECTION 4-D  Firms and Other <em>Persons</em> that <em>Solicit Municipal Advisor Clients</em> on the Applicant’s Behalf </b></p>
 
<p>Provide the name, address, and phone number of any firm or other <em>person</em> that is not otherwise an <em>associated person</em> of the applicant that <em>solicits municipal advisor clients</em> on the applicant’s behalf.  A separate Schedule D must be completed for each such firm or natural person. </p>

			<xsl:for-each select="m1:formData/m1:solicitingMACFirms/m1:solicitingMACFirm">
				<div class="tableStyle" style="margin-left:0; margin-right:0;">	
					<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">Name:  <br/>
								<textarea name="firmname" cols="64" rows="6" readonly="1"> 
							<xsl:value-of select="string(m1:name)" />	
							</textarea></div>
						</div>
						<div style="clear:both"></div>						
					</div>	
										
					<div class="tableStyle" style="margin-left:0; margin-right:0;">	
					<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">EDGAR CIK No. (if any):  
								<input  type="text" readonly="1"> 
									<xsl:attribute name="value"> 	
										<xsl:value-of select="string(m1:cik)" />	
									</xsl:attribute>
								</input>
								</div>
								<div class="tdstyle1max01sched tdmax01col1">	
								Individual <em>CRD</em> No. (if any): 
								<input  type="text" readonly="1"> 
									<xsl:attribute name="value"> 	
										<xsl:value-of select="string(m1:crd)" />	
									</xsl:attribute>
								</input>
							</div>
														
						</div>
						<div style="clear:both"></div>					
				</div>
		
				<div class="tableStyle" style="margin-left:0; margin-right:0;">	
					<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">Street Address 1:<br/>
									<input type="text" name="street1" readonly="1" size="40">
										<xsl:attribute name="value">
											<xsl:value-of select="string(m1:contactInfo/m1:addressInfo/ns2:address/ns1:street1)" />
										</xsl:attribute>
									</input>
									</div>
									<div class="tdstyle1max01sched tdmax01col1">Street Address 2:<br/>
									<input type="text" name="street1" readonly="1" size="40">
				                        <xsl:attribute name="value">
				                            <xsl:value-of select="string(m1:contactInfo/m1:addressInfo/ns2:address/ns1:street2)" />
				                        </xsl:attribute>
				                    </input>			                    
								</div>								
							</div>
							<div style="clear:both"></div>						
					</div>
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;">	
					<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">City:<br/>
									<input type="text" name="city" readonly="1" size="30">
										<xsl:attribute name="value">
											<xsl:value-of select="string(m1:contactInfo/m1:addressInfo/ns2:address/ns1:city)" />
										</xsl:attribute>
									</input>									
									</div>
								<div class="tdstyle1max01sched tdmax01col1">State/Country:									
				                <div class="fakeBox fakeBox4"> 
									<span >
										<xsl:call-template name="stateDescription">
											<xsl:with-param name="stateCode" select="string(m1:contactInfo/m1:addressInfo/ns2:address/ns1:stateOrCountry)" />
										 </xsl:call-template>
									 </span>
					    			 <span>
									 <xsl:text>&#160;</xsl:text>
					    			 </span>
				    			  </div>
							</div>
								</div>
					<div style="clear:both"></div>								
					</div>
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;">	
					<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">Postal Code:<br/>
							<input type="text" name="city" readonly="1" size="30">
								<xsl:attribute name="value">
									<xsl:value-of select="string(m1:contactInfo/m1:addressInfo/ns2:address/ns1:zipCode)" />
								</xsl:attribute>
							</input>
						</div>
					</div>
				<div style="clear:both"></div>								
					</div>
					
        	<div class="tableStyle" style="margin-left:0; margin-right:0;">	
					<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">Telephone number at this location:<br/>
							<input type="text" name="city" readonly="1" size="30">
								<xsl:attribute name="value">
									<xsl:value-of select="string(m1:contactInfo/m1:phoneNumber)" />
								</xsl:attribute>
							</input>
						</div>
						<div class="tdstyle1max01sched tdmax01col1">Fax number (if any) at this location:<br/>
							<input type="text" name="city" readonly="1" size="30">
								<xsl:attribute name="value">
									<xsl:value-of select="string(m1:contactInfo/m1:faxNumber)" />
								</xsl:attribute>
							</input>
<!-- 					(area code)  (fax number) -->
						</div>
					</div>
			<div style="clear:both"></div>								
					</div>
					
			<p>For non-US telephone and fax numbers, include country code with area code and local number.</p>
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
					<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">Is this address a private residence? 
				 		<xsl:choose>
						<xsl:when test="m1:contactInfo/m1:addressInfo/ns2:residentialAddressFlag= 'Y'">
							<img src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>
		           	 </div>
		          </div>
				  <div style="clear:both"></div>								
					</div>
					
	            <div class="tableStyle" style="margin-left:0; margin-right:0;">	
					<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01singlecol tdmax01textmargins">A private residential address will not be included in publicly available versions of this registration form.</div>   
			 	</div>
			  <div style="clear:both"></div>								
					</div>
	</xsl:for-each>

		<p><b>SECTION 4-E  Employees That Also Do Business Independently on the Applicant’s Behalf as <em>Affiliates</em> of the Applicant </b></p>

		<xsl:for-each select="m1:formData/m1:independentBusinessEmployees/m1:independentBusinessEmployee">
		<p><b>Name of <em>Employee</em>: </b> <span class="minutia">Enter all the letters of each name and not initials or other abbreviations.  
		If no middle name, enter NMN on that line.</span></p>

			<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
					<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">Last Name:<br/>
							<input type="text" name="city" readonly="1" size="60">
									<xsl:attribute name="value">
										<xsl:value-of select="string(m1:name/ns2:lastName)" />
									</xsl:attribute>
							</input> 
						</div>
					</div>
					 <div style="clear:both"></div>								
					</div>
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
					<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">First Name:<br/>
							<input type="text" name="city" readonly="1" size="60">
								<xsl:attribute name="value">
									<xsl:value-of select="string(m1:name/ns2:firstName)" />
								</xsl:attribute>
							</input> 
						</div>						
					</div>
					 <div style="clear:both"></div>								
					</div>
						
						
					<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
					<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">Middle Name: <br/>
							<input type="text" name="city" readonly="1" size="45">
								<xsl:attribute name="value">
									<xsl:value-of select="string(m1:name/ns2:middleName)" />
								</xsl:attribute>
							</input> 
						</div>
					</div>
					<div style="clear:both"></div>								
					</div>

			<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched tdmax01col1">EDGAR CIK No. (if any): 
			</div>
			<div class="tdstyle1max01sched tdmax01col2">
							<input  type="text" readonly="1"> 
								<xsl:attribute name="value"> 	
									<xsl:value-of select="string(m1:cik)"/>
								</xsl:attribute>
								</input>
						</div>
						</div>
						<div style="clear:both"></div>								
			</div>
						
						
						<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">Individual <em>CRD</em> Number (if any): 
						</div>
						<div class="tdstyle1max01sched tdmax01col2">
							<input  type="text" readonly="1"> 
								<xsl:attribute name="value">     
									<xsl:value-of select="string(m1:crd)" />    
								</xsl:attribute>
							</input>
						</div>
						</div>
						<div style="clear:both"></div>								
			</div>
					
				
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">Street Address 1:<br/>
							<input type="text" name="street1" readonly="1" size="60">
								<xsl:attribute name="value">
										<xsl:value-of select="string(m1:contactInfo/m1:addressInfo/ns2:address/ns1:street1)" />
								</xsl:attribute>
							</input>
						</div>
						</div>
						<div style="clear:both"></div>								
			</div>
						
						<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">Street Address 2:<br/>
							<input type="text" name="street2" readonly="1" size="60">
                        		<xsl:attribute name="value">
	                            	<xsl:value-of select="string(m1:contactInfo/m1:addressInfo/ns2:address/ns1:street2)" />
                        		</xsl:attribute>
                    		</input>
                    	</div>
					</div>
				<div style="clear:both"></div>								
			</div>
						
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">City:<br/>
							<input type="text" name="city" readonly="1" size="45">
								<xsl:attribute name="value">
									<xsl:value-of select="string(m1:contactInfo/m1:addressInfo/ns2:address/ns1:city)" />
								</xsl:attribute>
							</input>
						</div>
						</div>
				<div style="clear:both"></div>								
			</div>
			
			
						<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">State/Country:<br/>							
				           		<div class="fakeBox" style="margin-left:0px;"> 
				                <span>
									<xsl:call-template name="stateDescription">
										<xsl:with-param name="stateCode" select="string(m1:contactInfo/m1:addressInfo/ns2:address/ns1:stateOrCountry)" />
									 </xsl:call-template>
								 </span>
								 <span>
								 <xsl:text>&#160;</xsl:text>
								 </span>
							  </div>
						 </div>
					</div>
					<div style="clear:both"></div>								
			</div>
			
					<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">Postal Code:<br/>
							<input type="text" name="zip" readonly="1" size="30">
								<xsl:attribute name="value">
									<xsl:value-of select="string(m1:contactInfo/m1:addressInfo/ns2:address/ns1:zipCode)" />
								</xsl:attribute>
							</input>
						</div>
					</div>
				<div style="clear:both"></div>								
			</div>
					
        <div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">Telephone number at this location:<br/>
					<input type="text" name="phone" readonly="1" size="30">
						<xsl:attribute name="value">
							<xsl:value-of select="string(m1:contactInfo/m1:phoneNumber)" />
						</xsl:attribute>
					</input>
				</div>
				</div>
				<div style="clear:both"></div>								
			</div>
				
				 <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">Fax number (if any) at this location:<br/>
					<input type="text" name="fax" readonly="1" size="30">
						<xsl:attribute name="value">
							<xsl:value-of select="string(m1:contactInfo/m1:faxNumber)" />
						</xsl:attribute>
					</input>
				</div>
			</div>
			<div style="clear:both"></div>
		</div>					
		<p>For non-US telephone and fax numbers, include country code with area code and local number.</p>


			  <div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">Is this address a private residence? 
				 		<xsl:choose>
						<xsl:when
							test="m1:contactInfo/m1:addressInfo/ns2:residentialAddressFlag= 'Y'">
							<img src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>
		           	 </div>
		          </div>
				  <div style="clear:both"></div>
		</div>	
		
	             <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01singlecol tdmax01textmargins">A private residential address will not be included in publicly available versions of this registration form.</div>   
			 	</div>
				<div style="clear:both"></div>
		</div>
			 
	</xsl:for-each>

		<p><b>SECTION 5-B  Description of Primary Business (for businesses not listed in Part A of Item 5) </b></p>
		 
		<p>If you checked Item 5-B.2 describe the applicant’s primary business (not the applicant’s <em>municipal advisor-related</em> business):  </p>
		
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01singlecol tdmax01textmargins">
  			<div class="fakeBox">              
                <xsl:value-of
                        select="string(m1:formData/m1:otherNonMAABusinessPrimaryDescription)" />
                <span>
                    <xsl:text>&#160;</xsl:text>
                </span>
            </div>
        </div>
		</div>
				<div style="clear:both"></div>
		</div>    

		<p><b>SECTION 6  Financial Industry and Other Activities of <em>Associated Persons</em></b></p>
		 
		<p>The following information must be completed for each <em>associated person</em> in every category you checked in Item 6-A.   A separate Schedule D must be completed for each such <em>associated person</em>. </p>

		<xsl:for-each select="m1:formData/m1:fiaAssociatedPersons/m1:fiaAssociatedPerson">
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdStyle1">Select only one:  		
					<xsl:choose>
						<xsl:when
							test="(count(m1:type/ns2:add) &gt; 0) or (count(m1:type/ns2:newAdd) &gt; 0)">
							<img src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>Add<xsl:choose>
						<xsl:when
							test="count(m1:type/ns2:delete) &gt; 0">
							<img src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>Delete  <xsl:choose>
						<xsl:when
							test="count(m1:type/ns2:amend) &gt; 0">
							<img src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>Amend
				</div>
			</div>
			<div style="clear:both"></div>
		</div>    
		
					
	<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">Legal Name of <em>Associated Person</em>:   <br/>
				<textarea name="firmname" cols="64" rows="6" readonly="1">
					<xsl:value-of select="string(m1:legalName)" />
				</textarea>
			</div>
		</div>
		<div style="clear:both"></div>
		</div> 
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">Primary Business Name of <em>Associated Person</em>:    <br/>
				<textarea name="firmname" cols="64" rows="6" readonly="1">
					<xsl:value-of
						select="string(m1:primaryBusinessName)" />
				</textarea>
			</div>
		</div>
		<div style="clear:both"></div>
	</div>
	<br/>
	<p><b>A.  <em>Associated person</em> is a: </b> <span class="minutia"> Check all that apply.</span></p>
<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">
     	<xsl:choose>
						<xsl:when
							test="count(m1:apTypes[m1:fiaAPTypes='Broker-dealer municipal securities dealer or government securities broker or dealer']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
  (1) Broker-dealer, municipal securities dealer, or government securities broker or dealer<br />
  		<xsl:choose>
						<xsl:when
							test="count(m1:apTypes[m1:fiaAPTypes='Investment Company']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
 (2) Investment company (including mutual funds) <br />
  		<xsl:choose>
						<xsl:when
							test="count(m1:apTypes[m1:fiaAPTypes='Investment Adviser']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>   
  
  (3) <em>Investment adviser</em>  (including financial planners)<br />
  
  		<xsl:choose>
						<xsl:when
							test="count(m1:apTypes[m1:fiaAPTypes='Swap Dealer']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>   
  (4) Swap dealer <br />
  
    		<xsl:choose>
						<xsl:when
							test="count(m1:apTypes[m1:fiaAPTypes='Security-based swap dealer']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (5) Security-based swap dealer <br />
 
   		<xsl:choose>
						<xsl:when
							test="count(m1:apTypes[m1:fiaAPTypes='Major swap participant']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (6) Major swap participant <br />
  
    		<xsl:choose>
						<xsl:when
							test="count(m1:apTypes[m1:fiaAPTypes='Major security-based swap participant']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (7) Major security-based swap participant <br />
 
   		<xsl:choose>
						<xsl:when
							test="count(m1:apTypes[m1:fiaAPTypes='Commodity pool operator']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (8) Commodity pool operator (whether registered or exempt from registration) <br />
 
   		<xsl:choose>
						<xsl:when
							test="count(m1:apTypes[m1:fiaAPTypes='Commodity trading advisor']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (9) Commodity trading advisor (whether registered or exempt from registration) <br />
  
    		<xsl:choose>
						<xsl:when
							test="count(m1:apTypes[m1:fiaAPTypes='Futures commission merchant']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (10) Futures commission merchant <br />
 
   		<xsl:choose>
						<xsl:when
							test="count(m1:apTypes[m1:fiaAPTypes='Banking/Thrift institution']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (11) Banking or thrift institution<br />
  
    		<xsl:choose>
						<xsl:when
							test="count(m1:apTypes[m1:fiaAPTypes='Trust Company']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (12) Trust company<br />
    		<xsl:choose>
						<xsl:when
							test="count(m1:apTypes[m1:fiaAPTypes='Accountant or accounting firm']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (13) Accountant or accounting firm <br />
 
   		<xsl:choose>
						<xsl:when
							test="count(m1:apTypes[m1:fiaAPTypes='Lawyer or law firm']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (14) Attorney or law firm <br />
 
   		<xsl:choose>
						<xsl:when
							test="count(m1:apTypes[m1:fiaAPTypes='Insurance company or agency']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (15) Insurance company or agency <br />
 
   		<xsl:choose>
						<xsl:when
							test="count(m1:apTypes[m1:fiaAPTypes='Pension consultant']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (16) Pension consultant <br />
 
   		<xsl:choose>
						<xsl:when
							test="count(m1:apTypes[m1:fiaAPTypes='Real estate broker or dealer']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (17) Real estate broker or dealer <br />
 
   		<xsl:choose>
						<xsl:when
							test="count(m1:apTypes[m1:fiaAPTypes='Sponsor or syndicator of limited partnerships']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (18) Sponsor or syndicator of limited partnerships <br />
  
    		<xsl:choose>
						<xsl:when
							test="count(m1:apTypes[m1:fiaAPTypes='Engineer or engineering firm']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (19) Engineer or engineering firm <br />
 
   		<xsl:choose>
						<xsl:when
							test="count(m1:apTypes[m1:fiaAPTypes='Other municipal advisor']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose> 
  (20) Other <em>municipal advisor</em> 

</div>
</div>

<div style="clear:both"></div>
	</div>

<p><b>B.  Control Relationships and Foreign Relations</b></p>
<br/>
<p>
<b>(1)  Control Relationships</b><br/>
<div class="tableStyle" style="margin-left:0; margin-right:0;">	
	<div class="tableRow">
		<div class="tdstyle1max01sched tdmax01col1">
			 (a)  Does the applicant <em>control</em> or is it <em>controlled</em> by the <em>associated person</em>?   
			 <xsl:choose>
						<xsl:when
							test="m1:otherMunicipalAdviser/m1:isControlOrControlled = 'Y'">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" /> Yes <img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" /> No
						</xsl:when>
						<xsl:when
							test="m1:otherMunicipalAdviser/m1:isControlOrControlled = 'N'">
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" /> Yes <img
								src="Images/box-checked.jpg" alt="checkbox checked" /> No
						</xsl:when>

						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" /> Yes
								<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />No
						</xsl:otherwise>
					</xsl:choose>
			</div>
		</div>
	<div style="clear:both"></div>
</div>


<div class="tableStyle" style="margin-left:0; margin-right:0;">	
	<div class="tableRow">
		<div class="tdstyle1max01sched tdmax01col1">
			  (b)  Are the applicant and the <em>associated person</em> under common <em>control</em>?  
			 <xsl:choose>
						<xsl:when
							test="m1:otherMunicipalAdviser/m1:isUnderCommonControl = 'Y'">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" /> Yes <img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" /> No
						</xsl:when>
						<xsl:when
							test="m1:otherMunicipalAdviser/m1:isUnderCommonControl = 'N'">
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" /> Yes <img
								src="Images/box-checked.jpg" alt="checkbox checked" /> No
						</xsl:when>

						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" /> Yes
								<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />No
						</xsl:otherwise>
					</xsl:choose>
			</div>
		</div>
	<div style="clear:both"></div>
</div>

<p>
<b>(2)  <em>Foreign Financial Regulatory Authority</em> Registration  </b><br/>

<div class="tableStyle" style="margin-left:0; margin-right:0;">	
	<div class="tableRow">
		<div class="tdstyle1max01sched tdmax01col1">
			 (a)  Is the <em>associated person</em> registered with a <em>foreign financial regulatory authority</em>? 
			 <xsl:choose>
						<xsl:when
							test="m1:otherMunicipalAdviser/m1:isRegisteredWithFFRA = 'Y'">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" /> Yes <img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" /> No
						</xsl:when>
						<xsl:when
							test="m1:otherMunicipalAdviser/m1:isRegisteredWithFFRA = 'N'">
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" /> Yes <img
								src="Images/box-checked.jpg" alt="checkbox checked" /> No
						</xsl:when>

						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" /> Yes
								<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />No
						</xsl:otherwise>
					</xsl:choose>
			</div>
		</div>
	<div style="clear:both"></div>
</div>

	<div class="tableStyle" style="margin-left:0; margin-right:0;">	
	<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01singlecol tdmax01textmargins">
			 <!-- (b)  If the answer to (2)(a) is “Yes,” list in English the name of each <em>foreign financial regulatory authority</em>, the <em>associated person</em>’s registration number with that authority (if any), and the country in which the authority has jurisdiction. --> 
			 (b)  List the name, in English:  the name of each <em>foreign financial regulatory authority</em>, the <em>associated person</em>'s registration number with that authority (if any), and the country in which the authority has jurisdiction.
			</div>
		</div>
		<div style="clear:both"></div>
	</div>
	
			
			<xsl:for-each select="m1:otherMunicipalAdviser//m1:ffraRegistrations/m1:ffraRegistration">
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">
						<textarea name="firmname" cols="64" rows="6" readonly="1">
						<xsl:value-of
							select="string(m1:name)" />
					</textarea>
					</div>
				</div>
				<div style="clear:both"></div>
			</div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">English Name of <em>Foreign Financial Regulatory Authority</em>:</div>
				
							<div class="tdstyle1max01sched  tdmax01col1">
						<textarea name="firmname" cols="64" rows="6" readonly="1">
						<xsl:value-of
							select="string(m1:registrationNum)" />
					</textarea>
					</div>
				</div>
				<div style="clear:both"></div>
			</div>
				
				<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">Registration Number (if any): (Need to capture the right value from schema)
						<div class="fakeBox"> 
	                      <span >
		                    <xsl:call-template name="stateDescription">
		                        <xsl:with-param name="stateCode" select="string(m1:country)" />
		                     </xsl:call-template>
		             	 </span>
			              <span>
			                <xsl:text>&#160;</xsl:text>
			              </span>
			            </div>
					</div>
				</div>
				<div style="clear:both"></div>
			</div>
			
				<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">English Name of Country:
						<!-- 
						 <input
							type="text"					
							readonly="1" size="30">
							<xsl:attribute
								name="value">
							<xsl:value-of
								select="string(m1:country)" />
							</xsl:attribute>
						</input>
						-->
						<div class="fakeBox"> 
	                      <span >
		                    <xsl:call-template name="stateDescription">
		                        <xsl:with-param name="stateCode" select="string(m1:country)" />
		                     </xsl:call-template>
		             	 </span>
			              <span>
			                <xsl:text>&#160;</xsl:text>
			              </span>
			            </div>
              		</div>
					</div>
				<div style="clear:both"></div>
			</div>
			
			</xsl:for-each>
			
	

</p>

</p>

</xsl:for-each>


<!-- <p><b>SECTION 8  <em>Control Persons (on a basis other than 25% ownership or executive officer status)</em></b></p> -->
<p><b>SECTION 8	<em>Control Persons (on a basis other than 25% ownership or executive officer status)</em></b></p>

<!-- <p><b>Section 8-A.  A separate Schedule D must be completed for each <em>control person</em> not named in Item 1-A or Schedules A, B, or C that directly or indirectly <em>controls</em> the applicant’s management or policies. </b></p> -->
<p><b>Section 8-A. A separate Schedule D must be completed for each <em>control person</em> not named in Item 1-A. or Schedules A, B, or C that directly or indirectly <em>controls</em> the applicant's management or policies.</b></p>

<xsl:for-each select="m1:formData/m1:nonScheduleABCControllingPersons/m1:nonScheduleABCControllingPerson">
<p>Check only one box:  		<xsl:choose>
						<xsl:when
							test="count(m1:type/ns2:add) &gt; 0 or count(m1:type/ns2:newAdd) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>Add<xsl:choose>
						<xsl:when
							test="count(m1:type/ns2:delete) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>Delete  <xsl:choose>
						<xsl:when
							test="count(m1:type/ns2:amend) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>Amend</p>

		<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">The <em>control</em> person is a (check only one box):   
			</div>
			</div>
			<div style="clear:both"></div>
		</div>
		
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01singlecol tdmax01textmargins">
			<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>Firm or organization.  You must complete Section 8-A (1).</div>
		</div>
		
			<div style="clear:both"></div>
		</div>
		
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01singlecol tdmax01textmargins">
			<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonNatural) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>Natural person.  You must complete Section 8-A (2). </div>
		</div>
		<div style="clear:both"></div>
		</div>
		

<p><b>(1)  If the <em>control</em> person is a firm or organization: </b></p>


<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">
Name <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:nameOfFirm)" />
		</xsl:attribute>
	</input>
	</div>
	</div>
		<div style="clear:both"></div>
		</div>


<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">
			<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:maAdvisor) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose><em>Municipal Advisor</em>     
					</div>
		</div>
		<div style="clear:both"></div>
		</div>
		
		
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1" >Form MA-T Registration </div>
					</div>
					<div style="clear:both"></div>
		</div>
					
			<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1"><em>SEC</em> File No.:  <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:maAdvisor/m1:maTregistration/m1:regInfo/ns2:fileNumber)" />
		</xsl:attribute>
	</input></div>
	</div>
					<div style="clear:both"></div>
		</div>
	
	<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">Effective Date:    <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:maAdvisor/m1:maTregistration/m1:dateInfo/m1:effectiveDate)" />
		</xsl:attribute>
	</input>
	</div>
	</div>
		<div style="clear:both"></div>
		</div>
	
	<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">Termination Date:   <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:maAdvisor/m1:maTregistration/m1:dateInfo/m1:terminationDate)" />
		</xsl:attribute>
	</input></div>
	</div>
		<div style="clear:both"></div>
		</div>
							 

						
						
		<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">Termination Date:Form MA Registration  
			</div>
			</div>
			<div style="clear:both"></div>
		</div>
		
		<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1"><em>SEC</em> File No.:  <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:maAdvisor/m1:ma/m1:regInfo/ns2:fileNumber)" />
		</xsl:attribute>
	</input></div>
	</div>
			<div style="clear:both"></div>
		</div>
	
	<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">Effective Date:   
			<input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:maAdvisor/m1:ma/m1:dateInfo/m1:effectiveDate)" />
		</xsl:attribute>
	</input></div>
	</div>
			<div style="clear:both"></div>
		</div>
	
	<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">Termination Date: 
			<input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:maAdvisor/m1:ma/m1:dateInfo/m1:terminationDate)" />
		</xsl:attribute>
	</input></div>
	</div>
			<div style="clear:both"></div>
		</div>
							
							  
							 

			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">
			<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:mSecDealer) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>Municipal Securities Dealer 
					</div>
					</div>
			<div style="clear:both"></div>
		</div>
		
		
		<div class="tableStyle" style="margin-left:0; margin-right:0; border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1"><em>SEC</em> File No.: 
			<input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:mSecDealer//m1:regInfo/ns2:fileNumber)" />
		</xsl:attribute>
	</input></div>
	</div>
			<div style="clear:both"></div>
		</div>
		
	<div class="tableStyle" style="margin-left:0; margin-right:0; border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">Effective Date: 
			<input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:mSecDealer/m1:dateInfo/m1:effectiveDate)" />
		</xsl:attribute>
	</input></div>
	</div>
			<div style="clear:both"></div>
		</div>
	
	
	<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">Termination Date:   <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:mSecDealer/m1:dateInfo/m1:terminationDate)" />
		</xsl:attribute>
	</input></div>
	</div>
			<div style="clear:both"></div>
		</div>
		
							 
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1"><xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:brokerDealer) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>Broker-Dealer          </div>
		</div>
		
			<div style="clear:both"></div>
		</div>
		
		<div class="tableStyle" style="margin-left:0; margin-right:0; border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1"><em>SEC</em> File No.:  <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:brokerDealer//m1:regInfo/ns2:fileNumber)" />
		</xsl:attribute>
	</input></div>
	</div>		
			<div style="clear:both"></div>
		</div>
	
	<div class="tableStyle" style="margin-left:0; margin-right:0; border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">Organization <em>CRD</em> No.:  
                 <input  type="text" readonly="1"> 
                                 <xsl:attribute name="value">    
                           <xsl:value-of select="string(m1:nonScheduleABCControlPersonFirm/m1:brokerDealer//m1:regInfo/ns2:crdNumber)" />    
                      </xsl:attribute>
                 </input>
      </div>
	  </div>		
			<div style="clear:both"></div>
		</div>
		
		
	<div class="tableStyle" style="margin-left:0; margin-right:0; border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">Effective Date:    <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:brokerDealer/m1:dateInfo/m1:effectiveDate)" />
		</xsl:attribute>
	</input></div>
	</div>		
			<div style="clear:both"></div>
		</div>
	
	<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">Termination Date:   <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:brokerDealer/m1:dateInfo/m1:terminationDate)" />
		</xsl:attribute>
	</input></div>
	</div>		
			<div style="clear:both"></div>
		</div>
	
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1"><xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>Investment Adviser </div>
		</div>

			<div style="clear:both"></div>
		</div>
		
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">
			<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:sec) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose><em>SEC</em>-Registered      </div>
					</div>
					<div style="clear:both"></div>
		</div>
					
		<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1"><em>SEC</em> File No.:  <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:sec/m1:regInfo/ns2:fileNumber)" />
		</xsl:attribute>
	</input></div>
	</div>
					<div style="clear:both"></div>
		</div>

	<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">Organization <em>CRD</em> No.:    <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:sec/m1:regInfo/ns2:crdNumber)" />
		</xsl:attribute>
	</input></div>	
	</div>
					<div style="clear:both"></div>
		</div>
	
	<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">Effective Date:    <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:sec/m1:dateInfo/m1:effectiveDate)" />
		</xsl:attribute>
	</input></div>
	</div>
					<div style="clear:both"></div>
		</div>
	
	<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">Termination Date:   <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:sec/m1:dateInfo/m1:terminationDate)" />
		</xsl:attribute>
	   </input></div>
			</div>
			<div style="clear:both"></div>
		</div>
							  
		 
	<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">
		<xsl:choose>
			<xsl:when
				test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:exemptAdvisor/m1:regInfo) &gt; 0">
				<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:otherwise>
				<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>Exempt Reporting Adviser
		</div>
			</div>
			<div style="clear:both"></div>
		</div>
		
		
		<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">
					<em>SEC</em>
					File No.:
					<input type="text" readonly="1">
						<xsl:attribute name="value">    
                                               <xsl:value-of
							select="string(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:exemptAdvisor/m1:regInfo/ns2:fileNumber)" /> 
                                                  </xsl:attribute>
					</input>
				</div>
				</div>
			<div style="clear:both"></div>
		</div>

		<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">
					Organization
					<em>CRD</em>
					No.:
					<input type="text" readonly="1">
						<xsl:attribute name="value">    
                                                 <xsl:value-of
							select="string(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:exemptAdvisor/m1:regInfo/ns2:crdNumber)" />  
                                                     </xsl:attribute>
					</input>
				</div>
				</div>
			<div style="clear:both"></div>
		</div>
		
	
		<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">
					Effective Date:
					<input type="text" readonly="1">
						<xsl:attribute name="value">
					        <xsl:value-of
							select="string(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:exemptAdvisor/m1:dateInfo/m1:effectiveDate)" />
					        </xsl:attribute>
					</input>
				</div>
				</div>
			<div style="clear:both"></div>
		</div>
				
				<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">
					Termination Date:
					       <input type="text" readonly="1">
							<xsl:attribute name="value">
						        <xsl:value-of
								select="string(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:exemptAdvisor/m1:dateInfo/m1:terminationDate)" />
						        </xsl:attribute>
					       </input>
							</div>
						</div>
					<div style="clear:both"></div>
		</div>
				
			 <div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1"><xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>Registered in US State or Other US Jurisdiction  
					</div>
					</div>
					
					<div style="clear:both"></div>
		</div>
		
		
		<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1"><em>CRD</em> No.:    <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo/ns2:crdNumber)" />
		</xsl:attribute>
	</input></div>
	</div>					
					<div style="clear:both"></div>
		</div>
		
		
	<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">Effective Date:    <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:dateInfo/m1:effectiveDate)" />
		</xsl:attribute>
	</input></div>
	</div>					
					<div style="clear:both"></div>
		</div>
	
	
	<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">Termination Date:   <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:dateInfo/m1:terminationDate)" />
		</xsl:attribute>
	</input></div>
	</div>					
					<div style="clear:both"></div>
		</div>
							 
			
			<p><strong>If <em>control person</em></strong> is registered in a US state or other jurisdiction as an investment adviser, enter the organization <em>CRD</em> Number above.  In the table below, <strong>select</strong> each US state or jurisdiction in which the <strong><em>control person</em></strong> is so registered.   
Check all that apply.</p>

		<div class="tableStyle" style="margin-left:0; margin-right:0;">
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<strong>
						<div
							class="subLabel">US State or Jurisdiction</div>
						(Code)
					</strong>
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<strong>
						<div
							class="subLabel">US State or Jurisdiction</div>
						(Code)
					</strong>
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
	  <xsl:choose>
 	   						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='AL']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
		</xsl:choose>
						Alabama
					</div>
					(AL)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='MT']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Montana
					</div>
					(MT)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='AK']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Alaska
					</div>
					(AK)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='NE']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Nebraska
					</div>
					(NE)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='AZ']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Arizona
					</div>
					(AZ)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='NV']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Nevada
					</div>
					(NV)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='AR']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Arkansas
					</div>
					(AR)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='NH']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						New Hampshire
					</div>
					(NH)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='CA']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						California
					</div>
					(CA)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='NJ']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						New Jersey
					</div>
					(NJ)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='CO']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Colorado
					</div>
					(CO)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='NM']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						New Mexico
					</div>
					(NM)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='CT']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Connecticut
					</div>
					(CT)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='NY']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						New York
					</div>
					(NY)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='DE']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Delaware
					</div>
					(DE)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='NC']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						North Carolina
					</div>
					(NC)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='DC']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						District of Columbia
					</div>
					(DC)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='ND']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						North Dakota
					</div>
					(ND)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='FL']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Florida
					</div>
					(FL)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='OH']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Ohio
					</div>
					(OH)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='GA']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Georgia
					</div>
					(GA)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='OK']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Oklahoma
					</div>
					(OK)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='GU']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Guam
					</div>
					(GU)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='OR']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Oregon
					</div>
					(OR)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='HI']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Hawaii
					</div>
					(HI)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='PA']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Pennsylvania
					</div>
					(PA)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='ID']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Idaho
					</div>
					(ID)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='PR']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Puerto Rico
					</div>
					(PR)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='IL']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Illinois
					</div>
					(IL)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='RI']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Rhode Island
					</div>
					(RI)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='IN']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Indiana
					</div>
					(IN)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='SC']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						South Carolina
					</div>
					(SC)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='IA']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Iowa
					</div>
					(IA)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='SD']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						South Dakota
					</div>
					(SD)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='KS']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Kansas
					</div>
					(KS)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='TN']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Tennessee
					</div>
					(TN)
				</div>
			</div>
				<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='KY']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Kentucky
					</div>
					(KY)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='TX']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Texas
					</div>
					(TX)
				</div>
			</div>
				<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='LA']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Louisiana
					</div>
					(LA)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='UT']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Utah
					</div>
					(UT)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='ME']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Maine
					</div>
					(ME)
				</div>
					<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='VT']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Vermont
					</div>
					(VT)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='MD']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Maryland
					</div>
					(MD)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='VI']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Virgin Islands
					</div>
					(VI)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='MA']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Massachusetts
					</div>
					(MA)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='VA']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Virginia
					</div>
					(VA)
				</div>
			</div>
		<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='MI']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Michigan
					</div>
					(MI)
				</div>
					<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
			<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='WA']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Washington
					</div>
					(WA)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='MN']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Minnesota
					</div>
					(MN)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='WI']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Wisconsin
					</div>
					(WI)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='MS']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Mississippi
					</div>
					(MS)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='WV']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						West Virginia
					</div>
					(WV)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:investmentAdvisor/m1:state/m1:regInfo[ns2:state='MO']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Missouri
					</div>
					(MO)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
				</div>
			</div>
		</div>		
			
			
		
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1"><xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:gsBrokerDealer) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>Government Securities Broker-Dealer  </div>
				</div>
		<div style="clear:both"></div>
		</div>
				
				
		<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1"><em>SEC</em> File No.:  <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:gsBrokerDealer/m1:regInfo/ns2:fileNumber)" />
		</xsl:attribute>
	</input></div>
	</div>
		<div style="clear:both"></div>
		</div>
	
		<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">Bank Identifier:      <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:gsBrokerDealer/m1:regInfo/ns2:bankId)" />
		</xsl:attribute>
	</input></div>	
	</div>
		<div style="clear:both"></div>
		</div>
	
	<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">Effective Date:    <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:gsBrokerDealer/m1:dateInfo/m1:effectiveDate)" />
		</xsl:attribute>
	</input></div>
	</div>
		<div style="clear:both"></div>
		</div>
	
	
	<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">Termination Date:   <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:gsBrokerDealer/m1:dateInfo/m1:terminationDate)" />
		</xsl:attribute>
	</input></div>
	</div>
		<div style="clear:both"></div>
		</div>
		
							 
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01singlecol tdmax01textmargins"><xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:otherReg) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>Other <em>SEC</em> Registration (Specify) 
					<input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:otherReg/m1:regInfo/ns2:description)" />
		</xsl:attribute>
	</input>
	</div>
		</div>
		<div style="clear:both"></div>
		</div>
		

 <div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1"><em>SEC</em> File No. (if any):    <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:otherReg/m1:regInfo/ns2:fileNumber)" />
		</xsl:attribute>
	</input>
	</div>
	</div>
	<div style="clear:both"></div>
		</div>
	
	
	<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">EDGAR CIK (if any):       <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:otherReg/m1:regInfo/ns2:cik)" />
		</xsl:attribute>
	</input></div>
	</div>
	<div style="clear:both"></div>
		</div>	
	
	<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">Effective Date:    <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:otherReg/m1:dateInfo/m1:effectiveDate)" />
		</xsl:attribute>
	</input></div>
	</div>
	<div style="clear:both"></div>
		</div>	
	
	<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">Termination Date:   <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:otherReg/m1:dateInfo/m1:terminationDate)" />
		</xsl:attribute>
	</input></div>
	</div>
	<div style="clear:both"></div>
		</div>	
							  
		
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01singlecol tdmax01textmargins"><xsl:choose>
						<xsl:when
							test="count(m1:nonScheduleABCControlPersonFirm/m1:anotherReg) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>Another Federal or State Regulator (Specify) <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:anotherReg//m1:regInfo/ns2:description)" />
		</xsl:attribute>
	</input></div>
	</div>
	<div style="clear:both"></div>
		</div>
	
	
		
		<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">Registration No. (if any):   <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:anotherReg//m1:regInfo/ns2:registrationId)" />
		</xsl:attribute>
	</input></div>
	</div>
	<div style="clear:both"></div>
		</div>
		
		
	<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">Effective Date:    <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:anotherReg/m1:dateInfo/m1:effectiveDate)" />
		</xsl:attribute>
	</input></div>
	</div>
	<div style="clear:both"></div>
		</div>
	
	<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div class="tableRow">
			<div class="tdstyle1max01sched  tdmax01col1">Termination Date:   <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonFirm/m1:anotherReg/m1:dateInfo/m1:terminationDate)" />
		</xsl:attribute>
	</input></div>
	</div>
	<div style="clear:both"></div>
		</div>
							  		
	
<p>Business Address	</p>

<xsl:choose>
			<xsl:when
				test="count(m1:nonScheduleABCControlPersonFirm) &gt; 0">
		<p>
				<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><input
						type="text"
						name="street1"
						readonly="1" size="60">
						<xsl:attribute
							name="value">
							<xsl:value-of
							select="string(m1:contact/m1:addressInfo/ns2:address/ns1:street1)" />
						</xsl:attribute>
					</input>
					<br/>Street Address 1
					</div>
					</div>
					<div style="clear:both"></div>
					</div>
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1">
					<input
                        type="text"
                        name="street2"
                        readonly="1" size="60">
                        <xsl:attribute
                            name="value">
                            <xsl:value-of
                            select="string(m1:contact/m1:addressInfo/ns2:address/ns1:street2)" />
                        </xsl:attribute>
                    </input>
                    <br/>Street Address 2
					</div>
					</div>				
					
					<div style="clear:both"></div>
							</div>
						
					
					
						<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><input
						type="text"
						name="city"
						readonly="1" size="45">
						<xsl:attribute
							name="value">
							<xsl:value-of
							select="string(m1:contact/m1:addressInfo/ns2:address/ns1:city)" />
						</xsl:attribute>
					</input>
					<br/>City
					</div>
					</div>
					<div style="clear:both"></div>
							</div>	
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1">
								
					<!-- 
					<input
						type="text"
						name="city"
						readonly="1">
						<xsl:attribute
							name="value">
							<xsl:value-of
							select="string(m1:contact/m1:addressInfo/ns2:address/ns1:stateOrCountry)" />
						</xsl:attribute>
					</input>
					-->
					<div class="fakeBox"> 
                        <span >
                    <xsl:call-template name="stateDescription">
                        <xsl:with-param name="stateCode" select="string(m1:contact/m1:addressInfo/ns2:address/ns1:stateOrCountry)" />
                     </xsl:call-template>
                 </span>
                 <span>
                 <xsl:text>&#160;</xsl:text>
                 </span>
              </div>
					<br/>State/Country
					</div>
					</div>
					<div style="clear:both"></div>
							</div>	
					
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><input
						type="text"
						name="city"
						readonly="1" size="30">
						<xsl:attribute
							name="value">
							<xsl:value-of
							select="string(m1:contact/m1:addressInfo/ns2:address/ns1:zipCode)" />
						</xsl:attribute>
					</input>
					<br/>Zip+4/Postal code
					</div>
					</div>
					<div style="clear:both"></div>
							</div>	
					
        <div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><input
						type="text"
						name="city"
						readonly="1" size="30">
						<xsl:attribute
							name="value">
							<xsl:value-of
							select="string(m1:contact/m1:phoneNumber)" />
						</xsl:attribute>
					</input>
					<br/>Telephone number at this location<br/>
					</div>
					</div>
					<div style="clear:both"></div>
							</div>	
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><input
						type="text"
						name="city"
						readonly="1" size="30">
						<xsl:attribute
							name="value">
							<xsl:value-of
							select="string(m1:contact/m1:faxNumber)" />
						</xsl:attribute>
					</input>
					<br/>Fax number (if any) at this location<br/>
					</div>
					</div>
					<div style="clear:both"></div>
							</div>					
					
				</p>
				
				<p>
For non-US telephone and fax numbers, include country code with area code and local number.</p>
<p>
                    Is this address a private residence? A private residential address will not be included in publicly available versions of this registration form.
 
                    <xsl:choose>
                                            <xsl:when
                                                test="m1:contact/m1:addressInfo/ns2:residentialAddressFlag= 'Y'">
                                                <img
                                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <img
                                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                                            </xsl:otherwise>
                                        </xsl:choose>
                    <br/>This private residential address will not be included in publicly available versions of this registration form.
       </p>    
	</xsl:when>
	<xsl:otherwise>
	
	  		<p>
				<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
			<div class="tableRow">
				<div class="tdstyle1max01sched  tdmax01col1"><input
						type="text"
						name="street1"
						readonly="1" size="60">
					
					</input>
					<br/>Street Address 1
					</div>
					</div>
					<div style="clear:both"></div>
				</div>
					
					
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">
					<div class="tableRow">
					<div class="tdstyle1max01sched  tdmax01col1">	<input
                        type="text"
                        name="street2"
                        readonly="1" size="60">
                    
                    </input>
                    <br/>Street Address 2
                    </div>
							</div>
					<div style="clear:both"></div>
					</div>
					
						<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><input
						type="text"
						name="city"
						readonly="1" size="45">
				
					</input>
					<br/>City
					</div>
					</div>
					<div style="clear:both"></div>
							</div>
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><input
						type="text"
						name="city"
						readonly="1" size="45">
				
					</input>
					<br/>State/Country
					</div>
					</div>
					<div style="clear:both"></div>
							</div>
					
					
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><input
						type="text"
						name="city"
						readonly="1" size="30">
						
					</input>
					<br/>Zip+4/Postal code
					</div>
					</div>
					<div style="clear:both"></div>
							</div>
					
        <div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><input
						type="text"
						name="city"
						readonly="1" size="30">
						
					</input>
					<br/>Telephone number at this location<br/>
					</div>
					</div>
					<div style="clear:both"></div>
							</div>
					
					 <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><input
						type="text"
						name="city"
						readonly="1" size="30">
					</input>
					<br/>Fax number (if any) at this location<br/>
					</div>
					</div>
					<div style="clear:both"></div>
							</div>					
					
				</p>
				
				<p>
For non-US telephone and fax numbers, include country code with area code and local number.</p>

<p>
Is this address is a private residence?


						
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
								
	 <br/><p> <span class="minutia">A private residential address will not be included in publicly available versions of this registration form.</span></p>
   					
</p>	
	</xsl:otherwise>
	</xsl:choose>

		<p>
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
					<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">
		Briefly describe the nature of the <em>control</em>:   <br/>
		<textarea name="explain" cols="64" rows="6" readonly="1">     
			<xsl:if test="count(m1:nonScheduleABCControlPersonFirm) &gt; 0">	
						<xsl:value-of
								select="string(m1:description)" />
			</xsl:if>	
			
			</textarea>
			</div>
						</div>
						<div style="clear:both"></div>						
					</div>	
			
			</p>	
	<p><b>(2)  If <em>control</em> person is a natural person:  </b></p>

	<p>
		<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1">
				<input
				type="text"		
				readonly="1" size="75">
				<xsl:attribute
					name="value">
				<xsl:value-of
					select="string(m1:nonScheduleABCControlPersonNatural/m1:name/ns2:lastName)" />
				</xsl:attribute>
			</input><br/>
			Last Name
			</div>
					</div>
					<div style="clear:both"></div>
							</div>	

		
		<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1">

		 <input
				type="text"		
				readonly="1" size="75">
				<xsl:attribute
					name="value">
				<xsl:value-of
					select="string(m1:nonScheduleABCControlPersonNatural/m1:name/ns2:firstName)" />
				</xsl:attribute>
			</input><br/>
			First Name
		</div>
					</div>
					<div style="clear:both"></div>
							</div>	

				<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1">

		 <input
				type="text"		
				readonly="1" size="45">
				<xsl:attribute
					name="value">
				<xsl:value-of
					select="string(m1:nonScheduleABCControlPersonNatural/m1:name/ns2:middleName)" />
				</xsl:attribute>
			</input><br/>
			Middle Name

		</div>
					</div>
					<div style="clear:both"></div>
							</div>	
							
		<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1">  <input
				type="text"		
				readonly="1">
				<xsl:attribute
					name="value">
				<xsl:value-of
					select="string(m1:nonScheduleABCControlPersonNatural/m1:cik)" />
				</xsl:attribute>
			</input><br/>
			EDGAR CIK No. (if any) </div>
					</div>
					<div style="clear:both"></div>
							</div>	

			<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1">
		 <input
				type="text"		
				readonly="1">
				<xsl:attribute
					name="value">
				<xsl:value-of
					select="string(m1:nonScheduleABCControlPersonNatural/m1:crd)" />
				</xsl:attribute>
			</input><br/>
			Individual <em>CRD</em> No. (if any)

		</div>
					</div>
					<div style="clear:both"></div>
							</div>	

	<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1">

 <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonNatural/m1:dateInfo/m1:effectiveDate)" />
		</xsl:attribute>
	</input><br/>
	Effective Date

	</div>
					</div>
					<div style="clear:both"></div>
							</div>	

		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1">

 <input
		type="text"		
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:nonScheduleABCControlPersonNatural/m1:dateInfo/m1:terminationDate)" />
		</xsl:attribute>
	</input><br/>
	Termination Date

		</div>
					</div>
					<div style="clear:both"></div>
							</div>	
		
		</p>
	<p>
	<xsl:choose>
			<xsl:when
				test="count(m1:nonScheduleABCControlPersonNatural) &gt; 0">
				<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><input
						type="text"
						name="street1"
						readonly="1" size="60">
						<xsl:attribute
							name="value">
							<xsl:value-of
							select="string(m1:contact/m1:addressInfo/ns2:address/ns1:street1)" />
						</xsl:attribute>
					</input>
					<br/>Street Address
					</div>
					</div>
					<div style="clear:both"></div>
							</div>	
					
					
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><input
                        type="text"
                        name="street2"
                        readonly="1" size="60">
                        <xsl:attribute
                            name="value">
                            <xsl:value-of
                            select="string(m1:contact/m1:addressInfo/ns2:address/ns1:street2)" />
                        </xsl:attribute>
                    </input>
                    <br/>Street Address 2
                   </div>
					</div>
					<div style="clear:both"></div>
							</div>	
					
						<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><input
						type="text"
						name="city"
						readonly="1" size="45">
						<xsl:attribute
							name="value">
							<xsl:value-of
							select="string(m1:contact/m1:addressInfo/ns2:address/ns1:city)" />
						</xsl:attribute>
					</input>
					<br/>City
					 </div>
					</div>
					<div style="clear:both"></div>
							</div>	
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1">
					<!-- 
					<input
						type="text"
						name="city"
						readonly="1" size="45">
						<xsl:attribute
							name="value">
							<xsl:value-of
							select="string(m1:contact/m1:addressInfo/ns2:address/ns1:stateOrCountry)" />
						</xsl:attribute>
					</input>
					-->
					<div class="fakeBox"> 
                        <span >
                    <xsl:call-template name="stateDescription">
                        <xsl:with-param name="stateCode" select="string(m1:contact/m1:addressInfo/ns2:address/ns1:stateOrCountry)"/>
                     </xsl:call-template>
                 </span>
                 <span>
                 <xsl:text>&#160;</xsl:text>
                 </span>
              </div>
					<br/>State/Country
					 </div>
					</div>
					<div style="clear:both"></div>
							</div>	
					
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><input
						type="text"
						name="city"
						readonly="1" size="30">
						<xsl:attribute
							name="value">
							<xsl:value-of
							select="string(m1:contact/m1:addressInfo/ns2:address/ns1:zipCode)" />
						</xsl:attribute>
					</input>
					<br/>Zip+4/Postal code
					</div>
					</div>
					<div style="clear:both"></div>
							</div>	
					
      <div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><input
						type="text"
						name="city"
						readonly="1" size="30">
						<xsl:attribute
							name="value">
							<xsl:value-of
							select="string(m1:contact/m1:phoneNumber)" />
						</xsl:attribute>
					</input>
					<br/>Telephone number at this location<br/>
					</div>
					</div>
					<div style="clear:both"></div>
							</div>	
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><input
						type="text"
						name="city"
						readonly="1" size="30">
						<xsl:attribute
							name="value">
							<xsl:value-of
							select="string(m1:contact/m1:faxNumber)" />
						</xsl:attribute>
					</input>
					<br/>Fax number (if any) at this location<br/>
					</div>
					</div>
					<div style="clear:both"></div>
							</div>		
					<p>
			For non-US telephone and fax numbers, include country code with area code and local number.</p>

				<p>
				Is this address is a private residence?
				<xsl:choose>
						<xsl:when
							test="m1:contact/m1:addressInfo/ns2:residentialAddressFlag= 'Y'">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					
 <br/><p> <span class="minutia">A private residential address will not be included in publicly available versions of this registration form.</span></p>
   
</p>
<p>&#160;</p>
</xsl:when>

<xsl:otherwise>

	<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><input
						type="text"
						name="street1"
						readonly="1" size="60">
					
					</input>
					<br/>Street Address 1
					</div>
					</div>
					<div style="clear:both"></div>
							</div>						
					
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><input
                        type="text"
                        name="street2"
                        readonly="1" size="60">
                    
                    </input>
                    <br/>Street Address 2
                   </div>
					</div>
					<div style="clear:both"></div>
							</div>	
					
						<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><input
						type="text"
						name="city"
						readonly="1" size="45">
					
					</input>
					<br/>City
					</div>
					</div>
					<div style="clear:both"></div>
							</div>
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><input
						type="text"
						name="city"
						readonly="1" size="45">
					
					</input>
					<br/>State/Country
					</div>
					</div>
					<div style="clear:both"></div>
							</div>

						<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><input
						type="text"
						name="city"
						readonly="1" size="30">
					
					</input>
					<br/>Zip+4/Postal code
					</div>
					</div>
					<div style="clear:both"></div>
							</div>
					
        <div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><input
						type="text"
						name="city"
						readonly="1" size="30">
				
					</input>
					<br/>Telephone number at this location<br/>
					</div>
					</div>
					<div style="clear:both"></div>
							</div>
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><input
						type="text"
						name="city"
						readonly="1" size="30">
						
					</input>
					<br/>Fax number (if any) at this location<br/>
					</div>
					</div>
					<div style="clear:both"></div>
							</div>
	
					<p>
		For non-US telephone and fax numbers, include country code with area code and local number.</p>
		Is this address is a private residence? 
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />					
		<br/><span class="minutia">A private residential address will not be included in publicly available versions of this registration form.</span>


</xsl:otherwise>
		</xsl:choose></p>
		
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
					<div class="tableRow">
						<div class="tdstyle1max01sched tdmax01col1">
		Briefly describe the nature of the <em>control</em>:   <br/>
		<textarea name="explain" cols="64" rows="6" readonly="1">     
			<xsl:if
									test="count(m1:nonScheduleABCControlPersonNatural) &gt; 0">	
						<xsl:value-of
								select="string(m1:description)" />
			</xsl:if>	
			
			</textarea>
			</div>
						</div>
						<div style="clear:both"></div>						
					</div>	
			
			
		</xsl:for-each>
		<br/><br/>


<!-- <p><b>Section 8-B.</b>  If any <em>person</em> named in Schedules A, B, or C or in Section 8-A of this Schedule D is a public reporting company under Section 12 or 15(d) of the Securities Exchange Act of 1934, provide the information below.  A separate Section 8-B of Schedule D must be completed for each public reporting company.  </p> -->

<p><b>Section 8-B.</b>  If any <em>person</em> named in Schedules A, B, or C or in Section 8-A of this Schedule D is a public reporting company under Sections 12 or 15(d) of the Securities Exchange Act of 1934, provide the information below.  A separate Schedule D must be completed for each public reporting company.</p>

<xsl:for-each select="m1:formData/m1:section1215DPublicReportingCompanies/m1:section1215DPublicReportingCompany">

	<p>

	<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">
	(1)	Full legal name of the public reporting company:  	<br/>

	<textarea name="firmname" cols="64" rows="6" readonly="1">
			<xsl:value-of
				select="string(m1:name)" />
		</textarea>
		</div>
						</div>
						<div style="clear:both"></div>						
					</div>	
	</p>

	<p>
	<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">
	(2) The public reporting company’s EDGAR CIK number:    	<br/>
	<textarea name="firmname" cols="64" rows="6" readonly="1">
			<xsl:value-of
				select="string(m1:cik)" />
		</textarea>
		</div>
						</div>
						<div style="clear:both"></div>						
					</div>	
	</p>

<p>

		<p>(3) The Schedules where the public reporting company was reported: Check all that apply.
		</p>
		<p>
		<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1">
							<xsl:choose>
								<xsl:when
									test="m1:reportingSchedules/m1:reportingSchedule= 'Schedule A'">
									<img
										src="Images/box-checked.jpg" alt="checkbox checked" />
								</xsl:when>
								<xsl:otherwise>
									<img
										src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
								</xsl:otherwise>
							</xsl:choose>Schedule A
							</div>
					</div>
					<div style="clear:both"></div>
							</div>	
				
				
				<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><xsl:choose>
								<xsl:when
									test="m1:reportingSchedules/m1:reportingSchedule= 'Schedule B'">
									<img
										src="Images/box-checked.jpg" alt="checkbox checked" />
								</xsl:when>
								<xsl:otherwise>
									<img
										src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
								</xsl:otherwise>
							</xsl:choose>Schedule B
						</div>
					</div>
					<div style="clear:both"></div>
							</div>	
				
				
				<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><xsl:choose>
								<xsl:when
									test="m1:reportingSchedules/m1:reportingSchedule= 'Schedule C Section 4'">
									<img
										src="Images/box-checked.jpg" alt="checkbox checked" />
								</xsl:when>
								<xsl:otherwise>
									<img
										src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
								</xsl:otherwise>
							</xsl:choose>Schedule C, Section 4</div>
					</div>
					<div style="clear:both"></div>
							</div>	
				
				
				<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><xsl:choose>
								<xsl:when
									test="m1:reportingSchedules/m1:reportingSchedule= 'Schedule C Section 5'">
									<img
										src="Images/box-checked.jpg" alt="checkbox checked" />
								</xsl:when>
								<xsl:otherwise>
									<img
										src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
								</xsl:otherwise>
							</xsl:choose>Schedule C, Section 5
							</div>
					</div>
					<div style="clear:both"></div>
							</div>	
				
				
				<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01col1"><xsl:choose>
								<xsl:when
									test="m1:reportingSchedules/m1:reportingSchedule= 'Schedule D Section 8-A'">
									<img
										src="Images/box-checked.jpg" alt="checkbox checked" />
								</xsl:when>
								<xsl:otherwise>
									<img
										src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
								</xsl:otherwise>
							</xsl:choose>Schedule D, Section 8-A
							</div>
					</div>
					<div style="clear:both"></div>
							</div>	
			
		</p>

		</p>
</xsl:for-each>

<p><b>Schedule D:  MISCELLANEOUS</b></p> <br/>
  <p>
The space below may be used to explain a response to an Item or to provide any other information. </p>
<p>
<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched  tdmax01singlecol tdmax01textmargins">
<div class="fakeBox">
    <xsl:value-of
                        select="string(m1:formData/m1:miscellaneous)" />
                 <span>
                <xsl:text>&#160;</xsl:text>
               </span>
               </div>
			   </div>
					</div>
					<div style="clear:both"></div>
							</div>
</p>
</xsl:template>

</xsl:stylesheet>